/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddFacetToObjectRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, AddFacetToObjectRequest> {
    private final String directoryArn;
    private final SchemaFacet schemaFacet;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference objectReference;

    private AddFacetToObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.objectReference = builder.objectReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public SchemaFacet schemaFacet() {
        return this.schemaFacet;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFacetToObjectRequest)) {
            return false;
        }
        AddFacetToObjectRequest other = (AddFacetToObjectRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.schemaFacet(), other.schemaFacet()) && Objects.equals(this.objectAttributeList(), other.objectAttributeList()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public String toString() {
        return ToString.builder((String)"AddFacetToObjectRequest").add("DirectoryArn", (Object)this.directoryArn()).add("SchemaFacet", (Object)this.schemaFacet()).add("ObjectAttributeList", this.objectAttributeList()).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "SchemaFacet": {
                return Optional.of(clazz.cast(this.schemaFacet()));
            }
            case "ObjectAttributeList": {
                return Optional.of(clazz.cast(this.objectAttributeList()));
            }
            case "ObjectReference": {
                return Optional.of(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private SchemaFacet schemaFacet;
        private List<AttributeKeyAndValue> objectAttributeList;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AddFacetToObjectRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.schemaFacet(model.schemaFacet);
            this.objectAttributeList(model.objectAttributeList);
            this.objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return this.schemaFacet != null ? this.schemaFacet.toBuilder() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        public final Collection<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            return this.objectAttributeList != null ? (Collection)this.objectAttributeList.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... objectAttributeList) {
            this.objectAttributeList(Stream.of(objectAttributeList).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddFacetToObjectRequest build() {
            return new AddFacetToObjectRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, AddFacetToObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacet(SchemaFacet var1);

        default public Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return this.schemaFacet((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().apply(schemaFacet)).build());
        }

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(objectReference)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

