/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceRequestStatusResponse extends CloudControlResponse implements
        ToCopyableBuilder<GetResourceRequestStatusResponse.Builder, GetResourceRequestStatusResponse> {
    private static final SdkField<ProgressEvent> PROGRESS_EVENT_FIELD = SdkField
            .<ProgressEvent> builder(MarshallingType.SDK_POJO).memberName("ProgressEvent")
            .getter(getter(GetResourceRequestStatusResponse::progressEvent)).setter(setter(Builder::progressEvent))
            .constructor(ProgressEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressEvent").build()).build();

    private static final SdkField<List<HookProgressEvent>> HOOKS_PROGRESS_EVENT_FIELD = SdkField
            .<List<HookProgressEvent>> builder(MarshallingType.LIST)
            .memberName("HooksProgressEvent")
            .getter(getter(GetResourceRequestStatusResponse::hooksProgressEvent))
            .setter(setter(Builder::hooksProgressEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HooksProgressEvent").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HookProgressEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(HookProgressEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_EVENT_FIELD,
            HOOKS_PROGRESS_EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProgressEvent progressEvent;

    private final List<HookProgressEvent> hooksProgressEvent;

    private GetResourceRequestStatusResponse(BuilderImpl builder) {
        super(builder);
        this.progressEvent = builder.progressEvent;
        this.hooksProgressEvent = builder.hooksProgressEvent;
    }

    /**
     * <p>
     * Represents the current status of the resource operation request.
     * </p>
     * 
     * @return Represents the current status of the resource operation request.
     */
    public final ProgressEvent progressEvent() {
        return progressEvent;
    }

    /**
     * For responses, this returns true if the service returned a value for the HooksProgressEvent property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHooksProgressEvent() {
        return hooksProgressEvent != null && !(hooksProgressEvent instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists Hook invocations for the specified target in the request. This is a list since the same target can invoke
     * multiple Hooks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHooksProgressEvent} method.
     * </p>
     * 
     * @return Lists Hook invocations for the specified target in the request. This is a list since the same target can
     *         invoke multiple Hooks.
     */
    public final List<HookProgressEvent> hooksProgressEvent() {
        return hooksProgressEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressEvent());
        hashCode = 31 * hashCode + Objects.hashCode(hasHooksProgressEvent() ? hooksProgressEvent() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceRequestStatusResponse)) {
            return false;
        }
        GetResourceRequestStatusResponse other = (GetResourceRequestStatusResponse) obj;
        return Objects.equals(progressEvent(), other.progressEvent()) && hasHooksProgressEvent() == other.hasHooksProgressEvent()
                && Objects.equals(hooksProgressEvent(), other.hooksProgressEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceRequestStatusResponse").add("ProgressEvent", progressEvent())
                .add("HooksProgressEvent", hasHooksProgressEvent() ? hooksProgressEvent() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressEvent":
            return Optional.ofNullable(clazz.cast(progressEvent()));
        case "HooksProgressEvent":
            return Optional.ofNullable(clazz.cast(hooksProgressEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressEvent", PROGRESS_EVENT_FIELD);
        map.put("HooksProgressEvent", HOOKS_PROGRESS_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceRequestStatusResponse, T> g) {
        return obj -> g.apply((GetResourceRequestStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceRequestStatusResponse> {
        /**
         * <p>
         * Represents the current status of the resource operation request.
         * </p>
         * 
         * @param progressEvent
         *        Represents the current status of the resource operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressEvent(ProgressEvent progressEvent);

        /**
         * <p>
         * Represents the current status of the resource operation request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProgressEvent.Builder} avoiding the need
         * to create one manually via {@link ProgressEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgressEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #progressEvent(ProgressEvent)}.
         * 
         * @param progressEvent
         *        a consumer that will call methods on {@link ProgressEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressEvent(ProgressEvent)
         */
        default Builder progressEvent(Consumer<ProgressEvent.Builder> progressEvent) {
            return progressEvent(ProgressEvent.builder().applyMutation(progressEvent).build());
        }

        /**
         * <p>
         * Lists Hook invocations for the specified target in the request. This is a list since the same target can
         * invoke multiple Hooks.
         * </p>
         * 
         * @param hooksProgressEvent
         *        Lists Hook invocations for the specified target in the request. This is a list since the same target
         *        can invoke multiple Hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksProgressEvent(Collection<HookProgressEvent> hooksProgressEvent);

        /**
         * <p>
         * Lists Hook invocations for the specified target in the request. This is a list since the same target can
         * invoke multiple Hooks.
         * </p>
         * 
         * @param hooksProgressEvent
         *        Lists Hook invocations for the specified target in the request. This is a list since the same target
         *        can invoke multiple Hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksProgressEvent(HookProgressEvent... hooksProgressEvent);

        /**
         * <p>
         * Lists Hook invocations for the specified target in the request. This is a list since the same target can
         * invoke multiple Hooks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudcontrol.model.HookProgressEvent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudcontrol.model.HookProgressEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudcontrol.model.HookProgressEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #hooksProgressEvent(List<HookProgressEvent>)}.
         * 
         * @param hooksProgressEvent
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudcontrol.model.HookProgressEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hooksProgressEvent(java.util.Collection<HookProgressEvent>)
         */
        Builder hooksProgressEvent(Consumer<HookProgressEvent.Builder>... hooksProgressEvent);
    }

    static final class BuilderImpl extends CloudControlResponse.BuilderImpl implements Builder {
        private ProgressEvent progressEvent;

        private List<HookProgressEvent> hooksProgressEvent = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceRequestStatusResponse model) {
            super(model);
            progressEvent(model.progressEvent);
            hooksProgressEvent(model.hooksProgressEvent);
        }

        public final ProgressEvent.Builder getProgressEvent() {
            return progressEvent != null ? progressEvent.toBuilder() : null;
        }

        public final void setProgressEvent(ProgressEvent.BuilderImpl progressEvent) {
            this.progressEvent = progressEvent != null ? progressEvent.build() : null;
        }

        @Override
        public final Builder progressEvent(ProgressEvent progressEvent) {
            this.progressEvent = progressEvent;
            return this;
        }

        public final List<HookProgressEvent.Builder> getHooksProgressEvent() {
            List<HookProgressEvent.Builder> result = HooksProgressEventCopier.copyToBuilder(this.hooksProgressEvent);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHooksProgressEvent(Collection<HookProgressEvent.BuilderImpl> hooksProgressEvent) {
            this.hooksProgressEvent = HooksProgressEventCopier.copyFromBuilder(hooksProgressEvent);
        }

        @Override
        public final Builder hooksProgressEvent(Collection<HookProgressEvent> hooksProgressEvent) {
            this.hooksProgressEvent = HooksProgressEventCopier.copy(hooksProgressEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksProgressEvent(HookProgressEvent... hooksProgressEvent) {
            hooksProgressEvent(Arrays.asList(hooksProgressEvent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksProgressEvent(Consumer<HookProgressEvent.Builder>... hooksProgressEvent) {
            hooksProgressEvent(Stream.of(hooksProgressEvent).map(c -> HookProgressEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourceRequestStatusResponse build() {
            return new GetResourceRequestStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
