/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesRequest
extends CloudControlRequest
implements ToCopyableBuilder<Builder, ListResourcesRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ListResourcesRequest.getter(ListResourcesRequest::typeName)).setter(ListResourcesRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionId").getter(ListResourcesRequest.getter(ListResourcesRequest::typeVersionId)).setter(ListResourcesRequest.setter(Builder::typeVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ListResourcesRequest.getter(ListResourcesRequest::roleArn)).setter(ListResourcesRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcesRequest.getter(ListResourcesRequest::nextToken)).setter(ListResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourcesRequest.getter(ListResourcesRequest::maxResults)).setter(ListResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> RESOURCE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceModel").getter(ListResourcesRequest.getter(ListResourcesRequest::resourceModel)).setter(ListResourcesRequest.setter(Builder::resourceModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourcesRequest.memberNameToFieldInitializer();
    private final String typeName;
    private final String typeVersionId;
    private final String roleArn;
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceModel;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceModel = builder.resourceModel;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeVersionId() {
        return this.typeVersionId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String resourceModel() {
        return this.resourceModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceModel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeVersionId(), other.typeVersionId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceModel(), other.resourceModel());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesRequest").add("TypeName", (Object)this.typeName()).add("TypeVersionId", (Object)this.typeVersionId()).add("RoleArn", (Object)this.roleArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceModel", (Object)(this.resourceModel() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeVersionId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResourceModel": {
                return Optional.ofNullable(clazz.cast(this.resourceModel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ResourceModel", RESOURCE_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String typeVersionId;
        private String roleArn;
        private String nextToken;
        private Integer maxResults;
        private String resourceModel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            this.typeName(model.typeName);
            this.typeVersionId(model.typeVersionId);
            this.roleArn(model.roleArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceModel(model.resourceModel);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return this.typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceModel() {
            return this.resourceModel;
        }

        public final void setResourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
        }

        @Override
        public final Builder resourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesRequest> {
        public Builder typeName(String var1);

        public Builder typeVersionId(String var1);

        public Builder roleArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceModel(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

