/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesResponse
extends CloudControlResponse
implements ToCopyableBuilder<Builder, ListResourcesResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ListResourcesResponse.getter(ListResourcesResponse::typeName)).setter(ListResourcesResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<List<ResourceDescription>> RESOURCE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceDescriptions").getter(ListResourcesResponse.getter(ListResourcesResponse::resourceDescriptions)).setter(ListResourcesResponse.setter(Builder::resourceDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcesResponse.getter(ListResourcesResponse::nextToken)).setter(ListResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, RESOURCE_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("ResourceDescriptions", RESOURCE_DESCRIPTIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String typeName;
    private final List<ResourceDescription> resourceDescriptions;
    private final String nextToken;

    private ListResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.resourceDescriptions = builder.resourceDescriptions;
        this.nextToken = builder.nextToken;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final boolean hasResourceDescriptions() {
        return this.resourceDescriptions != null && !(this.resourceDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ResourceDescription> resourceDescriptions() {
        return this.resourceDescriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDescriptions() ? this.resourceDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesResponse)) {
            return false;
        }
        ListResourcesResponse other = (ListResourcesResponse)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && this.hasResourceDescriptions() == other.hasResourceDescriptions() && Objects.equals(this.resourceDescriptions(), other.resourceDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesResponse").add("TypeName", (Object)this.typeName()).add("ResourceDescriptions", this.hasResourceDescriptions() ? this.resourceDescriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "ResourceDescriptions": {
                return Optional.ofNullable(clazz.cast(this.resourceDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesResponse, T> g) {
        return obj -> g.apply((ListResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlResponse.BuilderImpl
    implements Builder {
        private String typeName;
        private List<ResourceDescription> resourceDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesResponse model) {
            super(model);
            this.typeName(model.typeName);
            this.resourceDescriptions(model.resourceDescriptions);
            this.nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<ResourceDescription.Builder> getResourceDescriptions() {
            List<ResourceDescription.Builder> result = ResourceDescriptionsCopier.copyToBuilder(this.resourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDescriptions(Collection<ResourceDescription.BuilderImpl> resourceDescriptions) {
            this.resourceDescriptions = ResourceDescriptionsCopier.copyFromBuilder(resourceDescriptions);
        }

        @Override
        public final Builder resourceDescriptions(Collection<ResourceDescription> resourceDescriptions) {
            this.resourceDescriptions = ResourceDescriptionsCopier.copy(resourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDescriptions(ResourceDescription ... resourceDescriptions) {
            this.resourceDescriptions(Arrays.asList(resourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDescriptions(Consumer<ResourceDescription.Builder> ... resourceDescriptions) {
            this.resourceDescriptions(Stream.of(resourceDescriptions).map(c -> (ResourceDescription)((ResourceDescription.Builder)ResourceDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourcesResponse build() {
            return new ListResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesResponse> {
        public Builder typeName(String var1);

        public Builder resourceDescriptions(Collection<ResourceDescription> var1);

        public Builder resourceDescriptions(ResourceDescription ... var1);

        public Builder resourceDescriptions(Consumer<ResourceDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

