/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceRequest
extends CloudControlRequest
implements ToCopyableBuilder<Builder, GetResourceRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(GetResourceRequest.getter(GetResourceRequest::typeName)).setter(GetResourceRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionId").getter(GetResourceRequest.getter(GetResourceRequest::typeVersionId)).setter(GetResourceRequest.setter(Builder::typeVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GetResourceRequest.getter(GetResourceRequest::roleArn)).setter(GetResourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetResourceRequest.getter(GetResourceRequest::identifier)).setter(GetResourceRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Identifier", IDENTIFIER_FIELD);
        }
    });
    private final String typeName;
    private final String typeVersionId;
    private final String roleArn;
    private final String identifier;

    private GetResourceRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.identifier = builder.identifier;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeVersionId() {
        return this.typeVersionId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String identifier() {
        return this.identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceRequest)) {
            return false;
        }
        GetResourceRequest other = (GetResourceRequest)((Object)obj);
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeVersionId(), other.typeVersionId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceRequest").add("TypeName", (Object)this.typeName()).add("TypeVersionId", (Object)this.typeVersionId()).add("RoleArn", (Object)this.roleArn()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeVersionId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceRequest, T> g) {
        return obj -> g.apply((GetResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlRequest.BuilderImpl
    implements Builder {
        private String typeName;
        private String typeVersionId;
        private String roleArn;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceRequest model) {
            super(model);
            this.typeName(model.typeName);
            this.typeVersionId(model.typeVersionId);
            this.roleArn(model.roleArn);
            this.identifier(model.identifier);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return this.typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceRequest build() {
            return new GetResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceRequest> {
        public Builder typeName(String var1);

        public Builder typeVersionId(String var1);

        public Builder roleArn(String var1);

        public Builder identifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

