/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceRequestStatusSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceRequestsResponse
extends CloudControlResponse
implements ToCopyableBuilder<Builder, ListResourceRequestsResponse> {
    private static final SdkField<List<ProgressEvent>> RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceRequestStatusSummaries").getter(ListResourceRequestsResponse.getter(ListResourceRequestsResponse::resourceRequestStatusSummaries)).setter(ListResourceRequestsResponse.setter(Builder::resourceRequestStatusSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequestStatusSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProgressEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceRequestsResponse.getter(ListResourceRequestsResponse::nextToken)).setter(ListResourceRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceRequestStatusSummaries", RESOURCE_REQUEST_STATUS_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ProgressEvent> resourceRequestStatusSummaries;
    private final String nextToken;

    private ListResourceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceRequestStatusSummaries = builder.resourceRequestStatusSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceRequestStatusSummaries() {
        return this.resourceRequestStatusSummaries != null && !(this.resourceRequestStatusSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProgressEvent> resourceRequestStatusSummaries() {
        return this.resourceRequestStatusSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequestStatusSummaries() ? this.resourceRequestStatusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRequestsResponse)) {
            return false;
        }
        ListResourceRequestsResponse other = (ListResourceRequestsResponse)((Object)obj);
        return this.hasResourceRequestStatusSummaries() == other.hasResourceRequestStatusSummaries() && Objects.equals(this.resourceRequestStatusSummaries(), other.resourceRequestStatusSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceRequestsResponse").add("ResourceRequestStatusSummaries", this.hasResourceRequestStatusSummaries() ? this.resourceRequestStatusSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceRequestStatusSummaries": {
                return Optional.ofNullable(clazz.cast(this.resourceRequestStatusSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRequestsResponse, T> g) {
        return obj -> g.apply((ListResourceRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudControlResponse.BuilderImpl
    implements Builder {
        private List<ProgressEvent> resourceRequestStatusSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRequestsResponse model) {
            super(model);
            this.resourceRequestStatusSummaries(model.resourceRequestStatusSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ProgressEvent.Builder> getResourceRequestStatusSummaries() {
            List<ProgressEvent.Builder> result = ResourceRequestStatusSummariesCopier.copyToBuilder(this.resourceRequestStatusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequestStatusSummaries(Collection<ProgressEvent.BuilderImpl> resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries = ResourceRequestStatusSummariesCopier.copyFromBuilder(resourceRequestStatusSummaries);
        }

        @Override
        public final Builder resourceRequestStatusSummaries(Collection<ProgressEvent> resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries = ResourceRequestStatusSummariesCopier.copy(resourceRequestStatusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequestStatusSummaries(ProgressEvent ... resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries(Arrays.asList(resourceRequestStatusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequestStatusSummaries(Consumer<ProgressEvent.Builder> ... resourceRequestStatusSummaries) {
            this.resourceRequestStatusSummaries(Stream.of(resourceRequestStatusSummaries).map(c -> (ProgressEvent)((ProgressEvent.Builder)ProgressEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceRequestsResponse build() {
            return new ListResourceRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceRequestsResponse> {
        public Builder resourceRequestStatusSummaries(Collection<ProgressEvent> var1);

        public Builder resourceRequestStatusSummaries(ProgressEvent ... var1);

        public Builder resourceRequestStatusSummaries(Consumer<ProgressEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

