/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandlerErrorCode {
    NOT_UPDATABLE("NotUpdatable"),
    INVALID_REQUEST("InvalidRequest"),
    ACCESS_DENIED("AccessDenied"),
    INVALID_CREDENTIALS("InvalidCredentials"),
    ALREADY_EXISTS("AlreadyExists"),
    NOT_FOUND("NotFound"),
    RESOURCE_CONFLICT("ResourceConflict"),
    THROTTLING("Throttling"),
    SERVICE_LIMIT_EXCEEDED("ServiceLimitExceeded"),
    NOT_STABILIZED("NotStabilized"),
    GENERAL_SERVICE_EXCEPTION("GeneralServiceException"),
    SERVICE_INTERNAL_ERROR("ServiceInternalError"),
    SERVICE_TIMEOUT("ServiceTimeout"),
    NETWORK_FAILURE("NetworkFailure"),
    INTERNAL_FAILURE("InternalFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandlerErrorCode> VALUE_MAP;
    private final String value;

    private HandlerErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandlerErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandlerErrorCode> knownValues() {
        EnumSet<HandlerErrorCode> knownValues = EnumSet.allOf(HandlerErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandlerErrorCode.class, HandlerErrorCode::toString);
    }
}

