/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudcontrol.CloudControlAsyncClient;
import software.amazon.awssdk.services.cloudcontrol.CloudControlAsyncClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.CloudControlServiceClientConfiguration;
import software.amazon.awssdk.services.cloudcontrol.DefaultCloudControlAsyncClient;
import software.amazon.awssdk.services.cloudcontrol.DefaultCloudControlBaseClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.endpoints.CloudControlEndpointProvider;

@SdkInternalApi
final class DefaultCloudControlAsyncClientBuilder
extends DefaultCloudControlBaseClientBuilder<CloudControlAsyncClientBuilder, CloudControlAsyncClient>
implements CloudControlAsyncClientBuilder {
    DefaultCloudControlAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudControlAsyncClientBuilder endpointProvider(CloudControlEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudControlAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudControlAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudControlServiceClientConfiguration serviceClientConfiguration = CloudControlServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudControlAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

