/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ClientTokenConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlException;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentOperationException;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GeneralServiceException;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerInternalFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidCredentialsException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse;
import software.amazon.awssdk.services.cloudcontrol.model.NetworkFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.NotStabilizedException;
import software.amazon.awssdk.services.cloudcontrol.model.NotUpdatableException;
import software.amazon.awssdk.services.cloudcontrol.model.PrivateTypeException;
import software.amazon.awssdk.services.cloudcontrol.model.RequestTokenNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceInternalErrorException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.cloudcontrol.model.ThrottlingException;
import software.amazon.awssdk.services.cloudcontrol.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.UnsupportedActionException;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.paginators.ListResourceRequestsIterable;
import software.amazon.awssdk.services.cloudcontrol.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.cloudcontrol.transform.CancelResourceRequestRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.GetResourceRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.ListResourceRequestsRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.waiters.CloudControlWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudControlClient
implements CloudControlClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudControlClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelResourceRequestResponse cancelResourceRequest(CancelResourceRequestRequest cancelResourceRequestRequest) throws ConcurrentModificationException, RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelResourceRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, cancelResourceRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelResourceRequest");
            CancelResourceRequestResponse cancelResourceRequestResponse = (CancelResourceRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelResourceRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelResourceRequestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelResourceRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelResourceRequestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$cancelResourceRequest$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, createResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResource");
            CreateResourceResponse createResourceResponse = (CreateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$createResource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, deleteResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResource");
            DeleteResourceResponse deleteResourceResponse = (DeleteResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$deleteResource$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, getResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResource");
            GetResourceResponse getResourceResponse = (GetResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$getResource$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceRequestStatusResponse getResourceRequestStatus(GetResourceRequestStatusRequest getResourceRequestStatusRequest) throws RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceRequestStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, getResourceRequestStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceRequestStatus");
            GetResourceRequestStatusResponse getResourceRequestStatusResponse = (GetResourceRequestStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceRequestStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceRequestStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceRequestStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceRequestStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$getResourceRequestStatus$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceRequestsResponse listResourceRequests(ListResourceRequestsRequest listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceRequestsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, listResourceRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceRequests");
            ListResourceRequestsResponse listResourceRequestsResponse = (ListResourceRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceRequests").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceRequestsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceRequestsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$listResourceRequests$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourceRequestsIterable listResourceRequestsPaginator(ListResourceRequestsRequest listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        return new ListResourceRequestsIterable(this, this.applyPaginatorUserAgent(listResourceRequestsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$listResources$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return new ListResourcesIterable(this, this.applyPaginatorUserAgent(listResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(this.clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResource");
            UpdateResourceResponse updateResourceResponse = (UpdateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$updateResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public CloudControlWaiter waiter() {
        return CloudControlWaiter.builder().client(this).build();
    }

    private <T extends CloudControlRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "cloudcontrolapi";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudControlException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandlerFailureException").exceptionBuilderSupplier(HandlerFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").exceptionBuilderSupplier(HandlerInternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").exceptionBuilderSupplier(ServiceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").exceptionBuilderSupplier(ServiceInternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PrivateTypeException").exceptionBuilderSupplier(PrivateTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").exceptionBuilderSupplier(RequestTokenNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").exceptionBuilderSupplier(ClientTokenConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NetworkFailureException").exceptionBuilderSupplier(NetworkFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").exceptionBuilderSupplier(ConcurrentOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedActionException").exceptionBuilderSupplier(UnsupportedActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotStabilizedException").exceptionBuilderSupplier(NotStabilizedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceConflictException").exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").exceptionBuilderSupplier(InvalidCredentialsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GeneralServiceException").exceptionBuilderSupplier(GeneralServiceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TypeNotFoundException").exceptionBuilderSupplier(TypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotUpdatableException").exceptionBuilderSupplier(NotUpdatableException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceRequests$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceRequestStatus$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResource$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResource$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelResourceRequest$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

