/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.CloudControlServiceClientConfiguration;
import software.amazon.awssdk.services.cloudcontrol.DefaultCloudControlBaseClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.DefaultCloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.endpoints.CloudControlEndpointProvider;

@SdkInternalApi
final class DefaultCloudControlClientBuilder
extends DefaultCloudControlBaseClientBuilder<CloudControlClientBuilder, CloudControlClient>
implements CloudControlClientBuilder {
    DefaultCloudControlClientBuilder() {
    }

    @Override
    public DefaultCloudControlClientBuilder endpointProvider(CloudControlEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudControlClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudControlClientBuilder.validateClientOptions(clientConfiguration);
        CloudControlServiceClientConfiguration serviceClientConfiguration = CloudControlServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCloudControlClient(serviceClientConfiguration, clientConfiguration);
    }
}

