/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Cloud9 development environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Environment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Environment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Environment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionType").getter(getter(Environment::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Environment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerArn").getter(getter(Environment::ownerArn)).setter(setter(Builder::ownerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()).build();

    private static final SdkField<EnvironmentLifecycle> LIFECYCLE_FIELD = SdkField
            .<EnvironmentLifecycle> builder(MarshallingType.SDK_POJO).memberName("lifecycle")
            .getter(getter(Environment::lifecycle)).setter(setter(Builder::lifecycle)).constructor(EnvironmentLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycle").build()).build();

    private static final SdkField<String> MANAGED_CREDENTIALS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedCredentialsStatus").getter(getter(Environment::managedCredentialsStatusAsString))
            .setter(setter(Builder::managedCredentialsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedCredentialsStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, CONNECTION_TYPE_FIELD, ARN_FIELD, OWNER_ARN_FIELD, LIFECYCLE_FIELD,
            MANAGED_CREDENTIALS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String type;

    private final String connectionType;

    private final String arn;

    private final String ownerArn;

    private final EnvironmentLifecycle lifecycle;

    private final String managedCredentialsStatus;

    private Environment(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.connectionType = builder.connectionType;
        this.arn = builder.arn;
        this.ownerArn = builder.ownerArn;
        this.lifecycle = builder.lifecycle;
        this.managedCredentialsStatus = builder.managedCredentialsStatus;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the environment.
     * </p>
     * 
     * @return The description for the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of environment. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ssh</code>: Your own server connects to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ssh</code>: Your own server connects to the environment.
     *         </p>
     *         </li>
     * @see EnvironmentType
     */
    public final EnvironmentType type() {
        return EnvironmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of environment. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ssh</code>: Your own server connects to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ssh</code>: Your own server connects to the environment.
     *         </p>
     *         </li>
     * @see EnvironmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is selected by
     * default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is
     *         selected by default.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is selected by
     * default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is
     *         selected by default.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment owner.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment owner.
     */
    public final String ownerArn() {
        return ownerArn;
    }

    /**
     * <p>
     * The state of the environment in its creation or deletion lifecycle.
     * </p>
     * 
     * @return The state of the environment in its creation or deletion lifecycle.
     */
    public final EnvironmentLifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment. Available
     * values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED_ON_CREATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_DEFAULT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_REMOVAL_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_DEFAULT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedCredentialsStatus} will return {@link ManagedCredentialsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #managedCredentialsStatusAsString}.
     * </p>
     * 
     * @return Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
     *         Available values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED_ON_CREATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_DEFAULT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_REMOVAL_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_DEFAULT</code>
     *         </p>
     *         </li>
     * @see ManagedCredentialsStatus
     */
    public final ManagedCredentialsStatus managedCredentialsStatus() {
        return ManagedCredentialsStatus.fromValue(managedCredentialsStatus);
    }

    /**
     * <p>
     * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment. Available
     * values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED_ON_CREATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_DEFAULT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_REMOVAL_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED_BY_OWNER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED_BY_DEFAULT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedCredentialsStatus} will return {@link ManagedCredentialsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #managedCredentialsStatusAsString}.
     * </p>
     * 
     * @return Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
     *         Available values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED_ON_CREATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_DEFAULT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_REMOVAL_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED_BY_OWNER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED_BY_DEFAULT</code>
     *         </p>
     *         </li>
     * @see ManagedCredentialsStatus
     */
    public final String managedCredentialsStatusAsString() {
        return managedCredentialsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerArn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(managedCredentialsStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(ownerArn(), other.ownerArn()) && Objects.equals(lifecycle(), other.lifecycle())
                && Objects.equals(managedCredentialsStatusAsString(), other.managedCredentialsStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Environment").add("Id", id()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("ConnectionType", connectionTypeAsString()).add("Arn", arn()).add("OwnerArn", ownerArn())
                .add("Lifecycle", lifecycle()).add("ManagedCredentialsStatus", managedCredentialsStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "connectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ownerArn":
            return Optional.ofNullable(clazz.cast(ownerArn()));
        case "lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "managedCredentialsStatus":
            return Optional.ofNullable(clazz.cast(managedCredentialsStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("connectionType", CONNECTION_TYPE_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("ownerArn", OWNER_ARN_FIELD);
        map.put("lifecycle", LIFECYCLE_FIELD);
        map.put("managedCredentialsStatus", MANAGED_CREDENTIALS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param id
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the environment.
         * </p>
         * 
         * @param description
         *        The description for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of environment. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ssh</code>: Your own server connects to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ssh</code>: Your own server connects to the environment.
         *        </p>
         *        </li>
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of environment. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ssh</code>: Your own server connects to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ssh</code>: Your own server connects to the environment.
         *        </p>
         *        </li>
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder type(EnvironmentType type);

        /**
         * <p>
         * The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is selected by
         * default.
         * </p>
         * 
         * @param connectionType
         *        The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is
         *        selected by default.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is selected by
         * default.
         * </p>
         * 
         * @param connectionType
         *        The connection type used for connecting to an Amazon EC2 environment. <code>CONNECT_SSH</code> is
         *        selected by default.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment owner.
         * </p>
         * 
         * @param ownerArn
         *        The Amazon Resource Name (ARN) of the environment owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerArn(String ownerArn);

        /**
         * <p>
         * The state of the environment in its creation or deletion lifecycle.
         * </p>
         * 
         * @param lifecycle
         *        The state of the environment in its creation or deletion lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(EnvironmentLifecycle lifecycle);

        /**
         * <p>
         * The state of the environment in its creation or deletion lifecycle.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentLifecycle.Builder} avoiding
         * the need to create one manually via {@link EnvironmentLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentLifecycle.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecycle(EnvironmentLifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link EnvironmentLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(EnvironmentLifecycle)
         */
        default Builder lifecycle(Consumer<EnvironmentLifecycle.Builder> lifecycle) {
            return lifecycle(EnvironmentLifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
         * Available values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED_ON_CREATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_DEFAULT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_REMOVAL_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_DEFAULT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedCredentialsStatus
         *        Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
         *        Available values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED_ON_CREATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_DEFAULT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_REMOVAL_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_DEFAULT</code>
         *        </p>
         *        </li>
         * @see ManagedCredentialsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCredentialsStatus
         */
        Builder managedCredentialsStatus(String managedCredentialsStatus);

        /**
         * <p>
         * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
         * Available values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED_ON_CREATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_DEFAULT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_REMOVAL_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED_BY_OWNER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED_BY_DEFAULT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedCredentialsStatus
         *        Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment.
         *        Available values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED_ON_CREATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_DEFAULT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_REMOVAL_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_REMOVAL_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_REMOVAL_BY_COLLABORATOR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED_BY_OWNER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED_BY_DEFAULT</code>
         *        </p>
         *        </li>
         * @see ManagedCredentialsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCredentialsStatus
         */
        Builder managedCredentialsStatus(ManagedCredentialsStatus managedCredentialsStatus);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String type;

        private String connectionType;

        private String arn;

        private String ownerArn;

        private EnvironmentLifecycle lifecycle;

        private String managedCredentialsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            id(model.id);
            name(model.name);
            description(model.description);
            type(model.type);
            connectionType(model.connectionType);
            arn(model.arn);
            ownerArn(model.ownerArn);
            lifecycle(model.lifecycle);
            managedCredentialsStatus(model.managedCredentialsStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwnerArn() {
            return ownerArn;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final EnvironmentLifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(EnvironmentLifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(EnvironmentLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final String getManagedCredentialsStatus() {
            return managedCredentialsStatus;
        }

        public final void setManagedCredentialsStatus(String managedCredentialsStatus) {
            this.managedCredentialsStatus = managedCredentialsStatus;
        }

        @Override
        public final Builder managedCredentialsStatus(String managedCredentialsStatus) {
            this.managedCredentialsStatus = managedCredentialsStatus;
            return this;
        }

        @Override
        public final Builder managedCredentialsStatus(ManagedCredentialsStatus managedCredentialsStatus) {
            this.managedCredentialsStatus(managedCredentialsStatus == null ? null : managedCredentialsStatus.toString());
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
