/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloud9.model.ConnectionType;
import software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycle;
import software.amazon.awssdk.services.cloud9.model.EnvironmentType;
import software.amazon.awssdk.services.cloud9.model.ManagedCredentialsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Environment.getter(Environment::id)).setter(Environment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Environment.getter(Environment::name)).setter(Environment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Environment.getter(Environment::description)).setter(Environment.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Environment.getter(Environment::typeAsString)).setter(Environment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionType").getter(Environment.getter(Environment::connectionTypeAsString)).setter(Environment.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Environment.getter(Environment::arn)).setter(Environment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerArn").getter(Environment.getter(Environment::ownerArn)).setter(Environment.setter(Builder::ownerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()}).build();
    private static final SdkField<EnvironmentLifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycle").getter(Environment.getter(Environment::lifecycle)).setter(Environment.setter(Builder::lifecycle)).constructor(EnvironmentLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycle").build()}).build();
    private static final SdkField<String> MANAGED_CREDENTIALS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedCredentialsStatus").getter(Environment.getter(Environment::managedCredentialsStatusAsString)).setter(Environment.setter(Builder::managedCredentialsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedCredentialsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CONNECTION_TYPE_FIELD, ARN_FIELD, OWNER_ARN_FIELD, LIFECYCLE_FIELD, MANAGED_CREDENTIALS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String type;
    private final String connectionType;
    private final String arn;
    private final String ownerArn;
    private final EnvironmentLifecycle lifecycle;
    private final String managedCredentialsStatus;

    private Environment(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.connectionType = builder.connectionType;
        this.arn = builder.arn;
        this.ownerArn = builder.ownerArn;
        this.lifecycle = builder.lifecycle;
        this.managedCredentialsStatus = builder.managedCredentialsStatus;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final EnvironmentType type() {
        return EnvironmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String ownerArn() {
        return this.ownerArn;
    }

    public final EnvironmentLifecycle lifecycle() {
        return this.lifecycle;
    }

    public final ManagedCredentialsStatus managedCredentialsStatus() {
        return ManagedCredentialsStatus.fromValue(this.managedCredentialsStatus);
    }

    public final String managedCredentialsStatusAsString() {
        return this.managedCredentialsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedCredentialsStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.ownerArn(), other.ownerArn()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.managedCredentialsStatusAsString(), other.managedCredentialsStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("Arn", (Object)this.arn()).add("OwnerArn", (Object)this.ownerArn()).add("Lifecycle", (Object)this.lifecycle()).add("ManagedCredentialsStatus", (Object)this.managedCredentialsStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ownerArn": {
                return Optional.ofNullable(clazz.cast(this.ownerArn()));
            }
            case "lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "managedCredentialsStatus": {
                return Optional.ofNullable(clazz.cast(this.managedCredentialsStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String type;
        private String connectionType;
        private String arn;
        private String ownerArn;
        private EnvironmentLifecycle lifecycle;
        private String managedCredentialsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.connectionType(model.connectionType);
            this.arn(model.arn);
            this.ownerArn(model.ownerArn);
            this.lifecycle(model.lifecycle);
            this.managedCredentialsStatus(model.managedCredentialsStatus);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getOwnerArn() {
            return this.ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        public final EnvironmentLifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(EnvironmentLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(EnvironmentLifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final String getManagedCredentialsStatus() {
            return this.managedCredentialsStatus;
        }

        @Override
        public final Builder managedCredentialsStatus(String managedCredentialsStatus) {
            this.managedCredentialsStatus = managedCredentialsStatus;
            return this;
        }

        @Override
        public final Builder managedCredentialsStatus(ManagedCredentialsStatus managedCredentialsStatus) {
            this.managedCredentialsStatus(managedCredentialsStatus == null ? null : managedCredentialsStatus.toString());
            return this;
        }

        public final void setManagedCredentialsStatus(String managedCredentialsStatus) {
            this.managedCredentialsStatus = managedCredentialsStatus;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(EnvironmentType var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder arn(String var1);

        public Builder ownerArn(String var1);

        public Builder lifecycle(EnvironmentLifecycle var1);

        default public Builder lifecycle(Consumer<EnvironmentLifecycle.Builder> lifecycle) {
            return this.lifecycle((EnvironmentLifecycle)((EnvironmentLifecycle.Builder)EnvironmentLifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder managedCredentialsStatus(String var1);

        public Builder managedCredentialsStatus(ManagedCredentialsStatus var1);
    }
}

