/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloud9.model.EnvironmentLifecycleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentLifecycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentLifecycle> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnvironmentLifecycle.getter(EnvironmentLifecycle::statusAsString)).setter(EnvironmentLifecycle.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(EnvironmentLifecycle.getter(EnvironmentLifecycle::reason)).setter(EnvironmentLifecycle.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> FAILURE_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureResource").getter(EnvironmentLifecycle.getter(EnvironmentLifecycle::failureResource)).setter(EnvironmentLifecycle.setter(Builder::failureResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD, FAILURE_RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String reason;
    private final String failureResource;

    private EnvironmentLifecycle(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.failureResource = builder.failureResource;
    }

    public final EnvironmentLifecycleStatus status() {
        return EnvironmentLifecycleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String reason() {
        return this.reason;
    }

    public final String failureResource() {
        return this.failureResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLifecycle)) {
            return false;
        }
        EnvironmentLifecycle other = (EnvironmentLifecycle)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.failureResource(), other.failureResource());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentLifecycle").add("Status", (Object)this.statusAsString()).add("Reason", (Object)this.reason()).add("FailureResource", (Object)this.failureResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "failureResource": {
                return Optional.ofNullable(clazz.cast(this.failureResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentLifecycle, T> g) {
        return obj -> g.apply((EnvironmentLifecycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String reason;
        private String failureResource;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLifecycle model) {
            this.status(model.status);
            this.reason(model.reason);
            this.failureResource(model.failureResource);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getFailureResource() {
            return this.failureResource;
        }

        @Override
        public final Builder failureResource(String failureResource) {
            this.failureResource = failureResource;
            return this;
        }

        public final void setFailureResource(String failureResource) {
            this.failureResource = failureResource;
        }

        public EnvironmentLifecycle build() {
            return new EnvironmentLifecycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentLifecycle> {
        public Builder status(String var1);

        public Builder status(EnvironmentLifecycleStatus var1);

        public Builder reason(String var1);

        public Builder failureResource(String var1);
    }
}

