/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.services.cloud9.model.MemberPermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentMembershipRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, CreateEnvironmentMembershipRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateEnvironmentMembershipRequest.getter(CreateEnvironmentMembershipRequest::environmentId)).setter(CreateEnvironmentMembershipRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(CreateEnvironmentMembershipRequest.getter(CreateEnvironmentMembershipRequest::userArn)).setter(CreateEnvironmentMembershipRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissions").getter(CreateEnvironmentMembershipRequest.getter(CreateEnvironmentMembershipRequest::permissionsAsString)).setter(CreateEnvironmentMembershipRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, USER_ARN_FIELD, PERMISSIONS_FIELD));
    private final String environmentId;
    private final String userArn;
    private final String permissions;

    private CreateEnvironmentMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.userArn = builder.userArn;
        this.permissions = builder.permissions;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final MemberPermissions permissions() {
        return MemberPermissions.fromValue(this.permissions);
    }

    public final String permissionsAsString() {
        return this.permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentMembershipRequest)) {
            return false;
        }
        CreateEnvironmentMembershipRequest other = (CreateEnvironmentMembershipRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.permissionsAsString(), other.permissionsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentMembershipRequest").add("EnvironmentId", (Object)this.environmentId()).add("UserArn", (Object)this.userArn()).add("Permissions", (Object)this.permissionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentMembershipRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String environmentId;
        private String userArn;
        private String permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentMembershipRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.userArn(model.userArn);
            this.permissions(model.permissions);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(MemberPermissions permissions) {
            this.permissions(permissions == null ? null : permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentMembershipRequest build() {
            return new CreateEnvironmentMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentMembershipRequest> {
        public Builder environmentId(String var1);

        public Builder userArn(String var1);

        public Builder permissions(String var1);

        public Builder permissions(MemberPermissions var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

