/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteEnvironmentMembershipRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, DeleteEnvironmentMembershipRequest> {
    private final String environmentId;
    private final String userArn;

    private DeleteEnvironmentMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.userArn = builder.userArn;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String userArn() {
        return this.userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentMembershipRequest)) {
            return false;
        }
        DeleteEnvironmentMembershipRequest other = (DeleteEnvironmentMembershipRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.userArn(), other.userArn());
    }

    public String toString() {
        return ToString.builder((String)"DeleteEnvironmentMembershipRequest").add("EnvironmentId", (Object)this.environmentId()).add("UserArn", (Object)this.userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String environmentId;
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentMembershipRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.userArn(model.userArn);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEnvironmentMembershipRequest build() {
            return new DeleteEnvironmentMembershipRequest(this);
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    CopyableBuilder<Builder, DeleteEnvironmentMembershipRequest> {
        public Builder environmentId(String var1);

        public Builder userArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

