/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.model.BadRequestException;
import software.amazon.awssdk.services.cloud9.model.Cloud9Exception;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.services.cloud9.model.ConflictException;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.cloud9.model.ForbiddenException;
import software.amazon.awssdk.services.cloud9.model.InternalServerErrorException;
import software.amazon.awssdk.services.cloud9.model.LimitExceededException;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.cloud9.model.NotFoundException;
import software.amazon.awssdk.services.cloud9.model.TooManyRequestsException;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsIterable;
import software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsIterable;
import software.amazon.awssdk.services.cloud9.transform.CreateEnvironmentEc2RequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.CreateEnvironmentEc2ResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.CreateEnvironmentMembershipRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.CreateEnvironmentMembershipResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.DeleteEnvironmentMembershipRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.DeleteEnvironmentMembershipResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.DeleteEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.DeleteEnvironmentResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentMembershipsRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentMembershipsResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentStatusRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentStatusResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.DescribeEnvironmentsResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.ListEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.ListEnvironmentsResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.UpdateEnvironmentMembershipRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.UpdateEnvironmentMembershipResponseUnmarshaller;
import software.amazon.awssdk.services.cloud9.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.cloud9.transform.UpdateEnvironmentResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloud9Client
implements Cloud9Client {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloud9Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "cloud9";
    }

    @Override
    public CreateEnvironmentEc2Response createEnvironmentEC2(CreateEnvironmentEc2Request createEnvironmentEc2Request) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEnvironmentEc2ResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateEnvironmentEc2Response)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentEc2Request).withMarshaller((Marshaller)new CreateEnvironmentEc2RequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateEnvironmentMembershipResponse createEnvironmentMembership(CreateEnvironmentMembershipRequest createEnvironmentMembershipRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEnvironmentMembershipResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateEnvironmentMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentMembershipRequest).withMarshaller((Marshaller)new CreateEnvironmentMembershipRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEnvironmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentRequest).withMarshaller((Marshaller)new DeleteEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEnvironmentMembershipResponse deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest deleteEnvironmentMembershipRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEnvironmentMembershipResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteEnvironmentMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentMembershipRequest).withMarshaller((Marshaller)new DeleteEnvironmentMembershipRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentMembershipsResponse describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest describeEnvironmentMembershipsRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentMembershipsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeEnvironmentMembershipsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentMembershipsRequest).withMarshaller((Marshaller)new DescribeEnvironmentMembershipsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentMembershipsIterable describeEnvironmentMembershipsPaginator(DescribeEnvironmentMembershipsRequest describeEnvironmentMembershipsRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        return new DescribeEnvironmentMembershipsIterable(this, this.applyPaginatorUserAgent(describeEnvironmentMembershipsRequest));
    }

    @Override
    public DescribeEnvironmentStatusResponse describeEnvironmentStatus(DescribeEnvironmentStatusRequest describeEnvironmentStatusRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeEnvironmentStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentStatusRequest).withMarshaller((Marshaller)new DescribeEnvironmentStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentsResponse describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEnvironmentsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentsRequest).withMarshaller((Marshaller)new DescribeEnvironmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnvironmentsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnvironmentsRequest).withMarshaller((Marshaller)new ListEnvironmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEnvironmentsIterable listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        return new ListEnvironmentsIterable(this, this.applyPaginatorUserAgent(listEnvironmentsRequest));
    }

    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnvironmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentRequest).withMarshaller((Marshaller)new UpdateEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEnvironmentMembershipResponse updateEnvironmentMembership(UpdateEnvironmentMembershipRequest updateEnvironmentMembershipRequest) throws BadRequestException, ConflictException, NotFoundException, ForbiddenException, TooManyRequestsException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, Cloud9Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnvironmentMembershipResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateEnvironmentMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentMembershipRequest).withMarshaller((Marshaller)new UpdateEnvironmentMembershipRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(Cloud9Exception.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends Cloud9Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Cloud9Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

