/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloud9.Cloud9AsyncClient;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse;

public class DescribeEnvironmentMembershipsPublisher
implements SdkPublisher<DescribeEnvironmentMembershipsResponse> {
    private final Cloud9AsyncClient client;
    private final DescribeEnvironmentMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEnvironmentMembershipsPublisher(Cloud9AsyncClient client, DescribeEnvironmentMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEnvironmentMembershipsPublisher(Cloud9AsyncClient client, DescribeEnvironmentMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEnvironmentMembershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEnvironmentMembershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeEnvironmentMembershipsPublisher resume(DescribeEnvironmentMembershipsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEnvironmentMembershipsPublisher(this.client, (DescribeEnvironmentMembershipsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEnvironmentMembershipsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEnvironmentMembershipsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEnvironmentMembershipsResponseFetcher
    implements AsyncPageFetcher<DescribeEnvironmentMembershipsResponse> {
        private DescribeEnvironmentMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeEnvironmentMembershipsResponse> nextPage(DescribeEnvironmentMembershipsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEnvironmentMembershipsPublisher.this.client.describeEnvironmentMemberships(DescribeEnvironmentMembershipsPublisher.this.firstRequest);
            }
            return DescribeEnvironmentMembershipsPublisher.this.client.describeEnvironmentMemberships((DescribeEnvironmentMembershipsRequest)((Object)DescribeEnvironmentMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

