/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloud9.Cloud9Client;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse;

public class ListEnvironmentsIterable
implements SdkIterable<ListEnvironmentsResponse> {
    private final Cloud9Client client;
    private final ListEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentsIterable(Cloud9Client client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public Iterator<ListEnvironmentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListEnvironmentsIterable resume(ListEnvironmentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEnvironmentsIterable(this.client, (ListEnvironmentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEnvironmentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEnvironmentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsIterable.this.client.listEnvironments(ListEnvironmentsIterable.this.firstRequest);
            }
            return ListEnvironmentsIterable.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

