/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.services.cloud9.model.Permissions;
import software.amazon.awssdk.services.cloud9.model.PermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentMembershipsRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, DescribeEnvironmentMembershipsRequest> {
    private final String userArn;
    private final String environmentId;
    private final List<String> permissions;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeEnvironmentMembershipsRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String userArn() {
        return this.userArn;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<Permissions> permissions() {
        return TypeConverter.convert(this.permissions, Permissions::fromValue);
    }

    public List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentMembershipsRequest)) {
            return false;
        }
        DescribeEnvironmentMembershipsRequest other = (DescribeEnvironmentMembershipsRequest)((Object)obj);
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentMembershipsRequest").add("UserArn", (Object)this.userArn()).add("EnvironmentId", (Object)this.environmentId()).add("Permissions", this.permissionsAsStrings()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.of(clazz.cast(this.userArn()));
            }
            case "environmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "permissions": {
                return Optional.of(clazz.cast(this.permissionsAsStrings()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String userArn;
        private String environmentId;
        private List<String> permissions;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentMembershipsRequest model) {
            super(model);
            this.userArn(model.userArn);
            this.environmentId(model.environmentId);
            this.permissions(model.permissions);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Collection<String> getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentMembershipsRequest build() {
            return new DescribeEnvironmentMembershipsRequest(this);
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentMembershipsRequest> {
        public Builder userArn(String var1);

        public Builder environmentId(String var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

