/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEnvironmentEC2Request
extends Cloud9Request
implements ToCopyableBuilder<Builder, CreateEnvironmentEC2Request> {
    private final String name;
    private final String description;
    private final String clientRequestToken;
    private final String instanceType;
    private final String subnetId;
    private final Integer automaticStopTimeMinutes;
    private final String ownerArn;

    private CreateEnvironmentEC2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
        this.ownerArn = builder.ownerArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Integer automaticStopTimeMinutes() {
        return this.automaticStopTimeMinutes;
    }

    public String ownerArn() {
        return this.ownerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticStopTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentEC2Request)) {
            return false;
        }
        CreateEnvironmentEC2Request other = (CreateEnvironmentEC2Request)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.automaticStopTimeMinutes(), other.automaticStopTimeMinutes()) && Objects.equals(this.ownerArn(), other.ownerArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateEnvironmentEC2Request").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("InstanceType", (Object)this.instanceType()).add("SubnetId", (Object)this.subnetId()).add("AutomaticStopTimeMinutes", (Object)this.automaticStopTimeMinutes()).add("OwnerArn", (Object)this.ownerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "clientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "instanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "subnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "automaticStopTimeMinutes": {
                return Optional.of(clazz.cast(this.automaticStopTimeMinutes()));
            }
            case "ownerArn": {
                return Optional.of(clazz.cast(this.ownerArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String clientRequestToken;
        private String instanceType;
        private String subnetId;
        private Integer automaticStopTimeMinutes;
        private String ownerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentEC2Request model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.automaticStopTimeMinutes(model.automaticStopTimeMinutes);
            this.ownerArn(model.ownerArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Integer getAutomaticStopTimeMinutes() {
            return this.automaticStopTimeMinutes;
        }

        @Override
        public final Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        public final void setAutomaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
        }

        public final String getOwnerArn() {
            return this.ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentEC2Request build() {
            return new CreateEnvironmentEC2Request(this);
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    CopyableBuilder<Builder, CreateEnvironmentEC2Request> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder instanceType(String var1);

        public Builder subnetId(String var1);

        public Builder automaticStopTimeMinutes(Integer var1);

        public Builder ownerArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

