/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Comprehensive evaluation metrics for synthetic data that assess both the utility of the generated data for machine
 * learning tasks and its privacy preservation characteristics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyntheticDataEvaluationScores implements SdkPojo, Serializable,
        ToCopyableBuilder<SyntheticDataEvaluationScores.Builder, SyntheticDataEvaluationScores> {
    private static final SdkField<DataPrivacyScores> DATA_PRIVACY_SCORES_FIELD = SdkField
            .<DataPrivacyScores> builder(MarshallingType.SDK_POJO).memberName("dataPrivacyScores")
            .getter(getter(SyntheticDataEvaluationScores::dataPrivacyScores)).setter(setter(Builder::dataPrivacyScores))
            .constructor(DataPrivacyScores::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacyScores").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PRIVACY_SCORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataPrivacyScores dataPrivacyScores;

    private SyntheticDataEvaluationScores(BuilderImpl builder) {
        this.dataPrivacyScores = builder.dataPrivacyScores;
    }

    /**
     * <p>
     * Privacy-specific evaluation scores that measure how well the synthetic data protects individual privacy,
     * including assessments of potential privacy risks such as membership inference attacks.
     * </p>
     * 
     * @return Privacy-specific evaluation scores that measure how well the synthetic data protects individual privacy,
     *         including assessments of potential privacy risks such as membership inference attacks.
     */
    public final DataPrivacyScores dataPrivacyScores() {
        return dataPrivacyScores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacyScores());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntheticDataEvaluationScores)) {
            return false;
        }
        SyntheticDataEvaluationScores other = (SyntheticDataEvaluationScores) obj;
        return Objects.equals(dataPrivacyScores(), other.dataPrivacyScores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyntheticDataEvaluationScores").add("DataPrivacyScores", dataPrivacyScores()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataPrivacyScores":
            return Optional.ofNullable(clazz.cast(dataPrivacyScores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataPrivacyScores", DATA_PRIVACY_SCORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyntheticDataEvaluationScores, T> g) {
        return obj -> g.apply((SyntheticDataEvaluationScores) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyntheticDataEvaluationScores> {
        /**
         * <p>
         * Privacy-specific evaluation scores that measure how well the synthetic data protects individual privacy,
         * including assessments of potential privacy risks such as membership inference attacks.
         * </p>
         * 
         * @param dataPrivacyScores
         *        Privacy-specific evaluation scores that measure how well the synthetic data protects individual
         *        privacy, including assessments of potential privacy risks such as membership inference attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacyScores(DataPrivacyScores dataPrivacyScores);

        /**
         * <p>
         * Privacy-specific evaluation scores that measure how well the synthetic data protects individual privacy,
         * including assessments of potential privacy risks such as membership inference attacks.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacyScores.Builder} avoiding the
         * need to create one manually via {@link DataPrivacyScores#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrivacyScores.Builder#build()} is called immediately and its
         * result is passed to {@link #dataPrivacyScores(DataPrivacyScores)}.
         * 
         * @param dataPrivacyScores
         *        a consumer that will call methods on {@link DataPrivacyScores.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacyScores(DataPrivacyScores)
         */
        default Builder dataPrivacyScores(Consumer<DataPrivacyScores.Builder> dataPrivacyScores) {
            return dataPrivacyScores(DataPrivacyScores.builder().applyMutation(dataPrivacyScores).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataPrivacyScores dataPrivacyScores;

        private BuilderImpl() {
        }

        private BuilderImpl(SyntheticDataEvaluationScores model) {
            dataPrivacyScores(model.dataPrivacyScores);
        }

        public final DataPrivacyScores.Builder getDataPrivacyScores() {
            return dataPrivacyScores != null ? dataPrivacyScores.toBuilder() : null;
        }

        public final void setDataPrivacyScores(DataPrivacyScores.BuilderImpl dataPrivacyScores) {
            this.dataPrivacyScores = dataPrivacyScores != null ? dataPrivacyScores.build() : null;
        }

        @Override
        public final Builder dataPrivacyScores(DataPrivacyScores dataPrivacyScores) {
            this.dataPrivacyScores = dataPrivacyScores;
            return this;
        }

        @Override
        public SyntheticDataEvaluationScores build() {
            return new SyntheticDataEvaluationScores(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
