/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the model training data channel. A training data channel is a named data source that the training
 * algorithms can consume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelTrainingDataChannel implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelTrainingDataChannel.Builder, ModelTrainingDataChannel> {
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlInputChannelArn").getter(getter(ModelTrainingDataChannel::mlInputChannelArn))
            .setter(setter(Builder::mlInputChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(ModelTrainingDataChannel::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3DataDistributionType").getter(getter(ModelTrainingDataChannel::s3DataDistributionTypeAsString))
            .setter(setter(Builder::s3DataDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataDistributionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_INPUT_CHANNEL_ARN_FIELD,
            CHANNEL_NAME_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mlInputChannelArn;

    private final String channelName;

    private final String s3DataDistributionType;

    private ModelTrainingDataChannel(BuilderImpl builder) {
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.channelName = builder.channelName;
        this.s3DataDistributionType = builder.s3DataDistributionType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML input channel for this model training data channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML input channel for this model training data channel.
     */
    public final String mlInputChannelArn() {
        return mlInputChannelArn;
    }

    /**
     * <p>
     * The name of the training data channel.
     * </p>
     * 
     * @return The name of the training data channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * Specifies how the training data stored in Amazon S3 should be distributed to training instances. This parameter
     * controls the data distribution strategy for the training job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is suitable for
     * smaller datasets and algorithms that require access to the complete dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key names.
     * This is suitable for larger datasets and distributed training scenarios where each instance processes a subset of
     * the data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link S3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
     *         parameter controls the data distribution strategy for the training job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is
     *         suitable for smaller datasets and algorithms that require access to the complete dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key
     *         names. This is suitable for larger datasets and distributed training scenarios where each instance
     *         processes a subset of the data.
     *         </p>
     *         </li>
     * @see S3DataDistributionType
     */
    public final S3DataDistributionType s3DataDistributionType() {
        return S3DataDistributionType.fromValue(s3DataDistributionType);
    }

    /**
     * <p>
     * Specifies how the training data stored in Amazon S3 should be distributed to training instances. This parameter
     * controls the data distribution strategy for the training job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is suitable for
     * smaller datasets and algorithms that require access to the complete dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key names.
     * This is suitable for larger datasets and distributed training scenarios where each instance processes a subset of
     * the data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link S3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
     *         parameter controls the data distribution strategy for the training job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is
     *         suitable for smaller datasets and algorithms that require access to the complete dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key
     *         names. This is suitable for larger datasets and distributed training scenarios where each instance
     *         processes a subset of the data.
     *         </p>
     *         </li>
     * @see S3DataDistributionType
     */
    public final String s3DataDistributionTypeAsString() {
        return s3DataDistributionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDistributionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelTrainingDataChannel)) {
            return false;
        }
        ModelTrainingDataChannel other = (ModelTrainingDataChannel) obj;
        return Objects.equals(mlInputChannelArn(), other.mlInputChannelArn())
                && Objects.equals(channelName(), other.channelName())
                && Objects.equals(s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelTrainingDataChannel").add("MlInputChannelArn", mlInputChannelArn())
                .add("ChannelName", channelName()).add("S3DataDistributionType", s3DataDistributionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mlInputChannelArn":
            return Optional.ofNullable(clazz.cast(mlInputChannelArn()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "s3DataDistributionType":
            return Optional.ofNullable(clazz.cast(s3DataDistributionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("s3DataDistributionType", S3_DATA_DISTRIBUTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelTrainingDataChannel, T> g) {
        return obj -> g.apply((ModelTrainingDataChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelTrainingDataChannel> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML input channel for this model training data channel.
         * </p>
         * 
         * @param mlInputChannelArn
         *        The Amazon Resource Name (ARN) of the ML input channel for this model training data channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlInputChannelArn(String mlInputChannelArn);

        /**
         * <p>
         * The name of the training data channel.
         * </p>
         * 
         * @param channelName
         *        The name of the training data channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
         * parameter controls the data distribution strategy for the training job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is suitable
         * for smaller datasets and algorithms that require access to the complete dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key
         * names. This is suitable for larger datasets and distributed training scenarios where each instance processes
         * a subset of the data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3DataDistributionType
         *        Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
         *        parameter controls the data distribution strategy for the training job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is
         *        suitable for smaller datasets and algorithms that require access to the complete dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3
         *        key names. This is suitable for larger datasets and distributed training scenarios where each instance
         *        processes a subset of the data.
         *        </p>
         *        </li>
         * @see S3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3DataDistributionType
         */
        Builder s3DataDistributionType(String s3DataDistributionType);

        /**
         * <p>
         * Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
         * parameter controls the data distribution strategy for the training job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is suitable
         * for smaller datasets and algorithms that require access to the complete dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3 key
         * names. This is suitable for larger datasets and distributed training scenarios where each instance processes
         * a subset of the data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3DataDistributionType
         *        Specifies how the training data stored in Amazon S3 should be distributed to training instances. This
         *        parameter controls the data distribution strategy for the training job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FullyReplicated</code> - The entire dataset is replicated on each training instance. This is
         *        suitable for smaller datasets and algorithms that require access to the complete dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShardedByS3Key</code> - The dataset is distributed across training instances based on Amazon S3
         *        key names. This is suitable for larger datasets and distributed training scenarios where each instance
         *        processes a subset of the data.
         *        </p>
         *        </li>
         * @see S3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3DataDistributionType
         */
        Builder s3DataDistributionType(S3DataDistributionType s3DataDistributionType);
    }

    static final class BuilderImpl implements Builder {
        private String mlInputChannelArn;

        private String channelName;

        private String s3DataDistributionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelTrainingDataChannel model) {
            mlInputChannelArn(model.mlInputChannelArn);
            channelName(model.channelName);
            s3DataDistributionType(model.s3DataDistributionType);
        }

        public final String getMlInputChannelArn() {
            return mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getS3DataDistributionType() {
            return s3DataDistributionType;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(S3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        @Override
        public ModelTrainingDataChannel build() {
            return new ModelTrainingDataChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
