/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an incremental training data channel that references a previously trained model. Incremental training allows
 * you to update an existing trained model with new data, building upon the knowledge from a base model rather than
 * training from scratch. This can significantly reduce training time and computational costs while improving model
 * performance with additional data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncrementalTrainingDataChannel implements SdkPojo, Serializable,
        ToCopyableBuilder<IncrementalTrainingDataChannel.Builder, IncrementalTrainingDataChannel> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(IncrementalTrainingDataChannel::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionIdentifier").getter(getter(IncrementalTrainingDataChannel::versionIdentifier))
            .setter(setter(Builder::versionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(IncrementalTrainingDataChannel::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD,
            VERSION_IDENTIFIER_FIELD, CHANNEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trainedModelArn;

    private final String versionIdentifier;

    private final String channelName;

    private IncrementalTrainingDataChannel(BuilderImpl builder) {
        this.trainedModelArn = builder.trainedModelArn;
        this.versionIdentifier = builder.versionIdentifier;
        this.channelName = builder.channelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the base trained model to use for incremental training. This model serves as
     * the starting point for the incremental training process.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the base trained model to use for incremental training. This model
     *         serves as the starting point for the incremental training process.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of the base trained model to use for incremental training. If not specified, the latest
     * version of the trained model is used.
     * </p>
     * 
     * @return The version identifier of the base trained model to use for incremental training. If not specified, the
     *         latest version of the trained model is used.
     */
    public final String versionIdentifier() {
        return versionIdentifier;
    }

    /**
     * <p>
     * The name of the incremental training data channel. This name is used to identify the channel during the training
     * process and must be unique within the training job.
     * </p>
     * 
     * @return The name of the incremental training data channel. This name is used to identify the channel during the
     *         training process and must be unique within the training job.
     */
    public final String channelName() {
        return channelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalTrainingDataChannel)) {
            return false;
        }
        IncrementalTrainingDataChannel other = (IncrementalTrainingDataChannel) obj;
        return Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(versionIdentifier(), other.versionIdentifier())
                && Objects.equals(channelName(), other.channelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncrementalTrainingDataChannel").add("TrainedModelArn", trainedModelArn())
                .add("VersionIdentifier", versionIdentifier()).add("ChannelName", channelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "versionIdentifier":
            return Optional.ofNullable(clazz.cast(versionIdentifier()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalTrainingDataChannel, T> g) {
        return obj -> g.apply((IncrementalTrainingDataChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncrementalTrainingDataChannel> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the base trained model to use for incremental training. This model serves
         * as the starting point for the incremental training process.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the base trained model to use for incremental training. This model
         *        serves as the starting point for the incremental training process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of the base trained model to use for incremental training. If not specified, the
         * latest version of the trained model is used.
         * </p>
         * 
         * @param versionIdentifier
         *        The version identifier of the base trained model to use for incremental training. If not specified,
         *        the latest version of the trained model is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdentifier(String versionIdentifier);

        /**
         * <p>
         * The name of the incremental training data channel. This name is used to identify the channel during the
         * training process and must be unique within the training job.
         * </p>
         * 
         * @param channelName
         *        The name of the incremental training data channel. This name is used to identify the channel during
         *        the training process and must be unique within the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);
    }

    static final class BuilderImpl implements Builder {
        private String trainedModelArn;

        private String versionIdentifier;

        private String channelName;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalTrainingDataChannel model) {
            trainedModelArn(model.trainedModelArn);
            versionIdentifier(model.versionIdentifier);
            channelName(model.channelName);
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getVersionIdentifier() {
            return versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        @Override
        public IncrementalTrainingDataChannel build() {
            return new IncrementalTrainingDataChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
