/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConfiguredModelAlgorithmAssociationRequest extends CleanRoomsMlRequest
        implements
        ToCopyableBuilder<DeleteConfiguredModelAlgorithmAssociationRequest.Builder, DeleteConfiguredModelAlgorithmAssociationRequest> {
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(DeleteConfiguredModelAlgorithmAssociationRequest::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(DeleteConfiguredModelAlgorithmAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configuredModelAlgorithmAssociationArn;

    private final String membershipIdentifier;

    private DeleteConfiguredModelAlgorithmAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.membershipIdentifier = builder.membershipIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that you want to delete.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The membership ID of the member that is deleting the configured model algorithm association.
     * </p>
     * 
     * @return The membership ID of the member that is deleting the configured model algorithm association.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfiguredModelAlgorithmAssociationRequest)) {
            return false;
        }
        DeleteConfiguredModelAlgorithmAssociationRequest other = (DeleteConfiguredModelAlgorithmAssociationRequest) obj;
        return Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConfiguredModelAlgorithmAssociationRequest")
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("MembershipIdentifier", membershipIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfiguredModelAlgorithmAssociationRequest, T> g) {
        return obj -> g.apply((DeleteConfiguredModelAlgorithmAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConfiguredModelAlgorithmAssociationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that you want to delete.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The membership ID of the member that is deleting the configured model algorithm association.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that is deleting the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String configuredModelAlgorithmAssociationArn;

        private String membershipIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfiguredModelAlgorithmAssociationRequest model) {
            super(model);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            membershipIdentifier(model.membershipIdentifier);
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfiguredModelAlgorithmAssociationRequest build() {
            return new DeleteConfiguredModelAlgorithmAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
