/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines where the training dataset is located, what type of data it contains, and how to access the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dataset implements SdkPojo, Serializable, ToCopyableBuilder<Dataset.Builder, Dataset> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Dataset::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<DatasetInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<DatasetInputConfig> builder(MarshallingType.SDK_POJO).memberName("inputConfig")
            .getter(getter(Dataset::inputConfig)).setter(setter(Builder::inputConfig)).constructor(DatasetInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TYPE_FIELD, INPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DatasetInputConfig inputConfig;

    private Dataset(BuilderImpl builder) {
        this.type = builder.type;
        this.inputConfig = builder.inputConfig;
    }

    /**
     * <p>
     * What type of information is found in the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return What type of information is found in the dataset.
     * @see DatasetType
     */
    public final DatasetType type() {
        return DatasetType.fromValue(type);
    }

    /**
     * <p>
     * What type of information is found in the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return What type of information is found in the dataset.
     * @see DatasetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A DatasetInputConfig object that defines the data source and schema mapping.
     * </p>
     * 
     * @return A DatasetInputConfig object that defines the data source and schema mapping.
     */
    public final DatasetInputConfig inputConfig() {
        return inputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(inputConfig(), other.inputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dataset").add("Type", typeAsString()).add("InputConfig", inputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "inputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("inputConfig", INPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dataset, T> g) {
        return obj -> g.apply((Dataset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dataset> {
        /**
         * <p>
         * What type of information is found in the dataset.
         * </p>
         * 
         * @param type
         *        What type of information is found in the dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder type(String type);

        /**
         * <p>
         * What type of information is found in the dataset.
         * </p>
         * 
         * @param type
         *        What type of information is found in the dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder type(DatasetType type);

        /**
         * <p>
         * A DatasetInputConfig object that defines the data source and schema mapping.
         * </p>
         * 
         * @param inputConfig
         *        A DatasetInputConfig object that defines the data source and schema mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(DatasetInputConfig inputConfig);

        /**
         * <p>
         * A DatasetInputConfig object that defines the data source and schema mapping.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetInputConfig.Builder} avoiding the
         * need to create one manually via {@link DatasetInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetInputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfig(DatasetInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link DatasetInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(DatasetInputConfig)
         */
        default Builder inputConfig(Consumer<DatasetInputConfig.Builder> inputConfig) {
            return inputConfig(DatasetInputConfig.builder().applyMutation(inputConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DatasetInputConfig inputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            type(model.type);
            inputConfig(model.inputConfig);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DatasetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DatasetInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(DatasetInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(DatasetInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        @Override
        public Dataset build() {
            return new Dataset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
