/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnSchema implements SdkPojo, Serializable, ToCopyableBuilder<ColumnSchema.Builder, ColumnSchema> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(ColumnSchema::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<List<String>> COLUMN_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("columnTypes")
            .getter(getter(ColumnSchema::columnTypesAsStrings))
            .setter(setter(Builder::columnTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final List<String> columnTypes;

    private ColumnSchema(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnTypes = builder.columnTypes;
    }

    /**
     * <p>
     * The name of a column.
     * </p>
     * 
     * @return The name of a column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The data type of column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnTypes} method.
     * </p>
     * 
     * @return The data type of column.
     */
    public final List<ColumnType> columnTypes() {
        return ColumnTypeListCopier.copyStringToEnum(columnTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnTypes() {
        return columnTypes != null && !(columnTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data type of column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnTypes} method.
     * </p>
     * 
     * @return The data type of column.
     */
    public final List<String> columnTypesAsStrings() {
        return columnTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnTypes() ? columnTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema other = (ColumnSchema) obj;
        return Objects.equals(columnName(), other.columnName()) && hasColumnTypes() == other.hasColumnTypes()
                && Objects.equals(columnTypesAsStrings(), other.columnTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnSchema").add("ColumnName", columnName())
                .add("ColumnTypes", hasColumnTypes() ? columnTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "columnTypes":
            return Optional.ofNullable(clazz.cast(columnTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columnName", COLUMN_NAME_FIELD);
        map.put("columnTypes", COLUMN_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnSchema, T> g) {
        return obj -> g.apply((ColumnSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnSchema> {
        /**
         * <p>
         * The name of a column.
         * </p>
         * 
         * @param columnName
         *        The name of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The data type of column.
         * </p>
         * 
         * @param columnTypes
         *        The data type of column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTypesWithStrings(Collection<String> columnTypes);

        /**
         * <p>
         * The data type of column.
         * </p>
         * 
         * @param columnTypes
         *        The data type of column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTypesWithStrings(String... columnTypes);

        /**
         * <p>
         * The data type of column.
         * </p>
         * 
         * @param columnTypes
         *        The data type of column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTypes(Collection<ColumnType> columnTypes);

        /**
         * <p>
         * The data type of column.
         * </p>
         * 
         * @param columnTypes
         *        The data type of column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTypes(ColumnType... columnTypes);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private List<String> columnTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnSchema model) {
            columnName(model.columnName);
            columnTypesWithStrings(model.columnTypes);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Collection<String> getColumnTypes() {
            if (columnTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return columnTypes;
        }

        public final void setColumnTypes(Collection<String> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copy(columnTypes);
        }

        @Override
        public final Builder columnTypesWithStrings(Collection<String> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copy(columnTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnTypesWithStrings(String... columnTypes) {
            columnTypesWithStrings(Arrays.asList(columnTypes));
            return this;
        }

        @Override
        public final Builder columnTypes(Collection<ColumnType> columnTypes) {
            this.columnTypes = ColumnTypeListCopier.copyEnumToString(columnTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnTypes(ColumnType... columnTypes) {
            columnTypes(Arrays.asList(columnTypes));
            return this;
        }

        @Override
        public ColumnSchema build() {
            return new ColumnSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
