/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelTrainedModelInferenceJobRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<CancelTrainedModelInferenceJobRequest.Builder, CancelTrainedModelInferenceJobRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CancelTrainedModelInferenceJobRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("trainedModelInferenceJobArn")
            .getter(getter(CancelTrainedModelInferenceJobRequest::trainedModelInferenceJobArn))
            .setter(setter(Builder::trainedModelInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelInferenceJobArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String trainedModelInferenceJobArn;

    private CancelTrainedModelInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.trainedModelInferenceJobArn = builder.trainedModelInferenceJobArn;
    }

    /**
     * <p>
     * The membership ID of the trained model inference job that you want to cancel.
     * </p>
     * 
     * @return The membership ID of the trained model inference job that you want to cancel.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model inference job that you want to cancel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model inference job that you want to cancel.
     */
    public final String trainedModelInferenceJobArn() {
        return trainedModelInferenceJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelInferenceJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelTrainedModelInferenceJobRequest)) {
            return false;
        }
        CancelTrainedModelInferenceJobRequest other = (CancelTrainedModelInferenceJobRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(trainedModelInferenceJobArn(), other.trainedModelInferenceJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelTrainedModelInferenceJobRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("TrainedModelInferenceJobArn", trainedModelInferenceJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "trainedModelInferenceJobArn":
            return Optional.ofNullable(clazz.cast(trainedModelInferenceJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("trainedModelInferenceJobArn", TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelTrainedModelInferenceJobRequest, T> g) {
        return obj -> g.apply((CancelTrainedModelInferenceJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelTrainedModelInferenceJobRequest> {
        /**
         * <p>
         * The membership ID of the trained model inference job that you want to cancel.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the trained model inference job that you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model inference job that you want to cancel.
         * </p>
         * 
         * @param trainedModelInferenceJobArn
         *        The Amazon Resource Name (ARN) of the trained model inference job that you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String trainedModelInferenceJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelTrainedModelInferenceJobRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            trainedModelInferenceJobArn(model.trainedModelInferenceJobArn);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getTrainedModelInferenceJobArn() {
            return trainedModelInferenceJobArn;
        }

        public final void setTrainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
        }

        @Override
        public final Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelTrainedModelInferenceJobRequest build() {
            return new CancelTrainedModelInferenceJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
