/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the configured audience generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceGenerationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceGenerationJobSummary.Builder, AudienceGenerationJobSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(AudienceGenerationJobSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AudienceGenerationJobSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceGenerationJobArn").getter(getter(AudienceGenerationJobSummary::audienceGenerationJobArn))
            .setter(setter(Builder::audienceGenerationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AudienceGenerationJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AudienceGenerationJobSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AudienceGenerationJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(AudienceGenerationJobSummary::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(AudienceGenerationJobSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(AudienceGenerationJobSummary::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, AUDIENCE_GENERATION_JOB_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, COLLABORATION_ID_FIELD, STARTED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String audienceGenerationJobArn;

    private final String name;

    private final String description;

    private final String status;

    private final String configuredAudienceModelArn;

    private final String collaborationId;

    private final String startedBy;

    private AudienceGenerationJobSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.collaborationId = builder.collaborationId;
        this.startedBy = builder.startedBy;
    }

    /**
     * <p>
     * The time at which the audience generation job was created.
     * </p>
     * 
     * @return The time at which the audience generation job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the audience generation job was updated.
     * </p>
     * 
     * @return The most recent time at which the audience generation job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience generation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience generation job.
     */
    public final String audienceGenerationJobArn() {
        return audienceGenerationJobArn;
    }

    /**
     * <p>
     * The name of the audience generation job.
     * </p>
     * 
     * @return The name of the audience generation job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the audience generation job.
     * </p>
     * 
     * @return The description of the audience generation job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the audience generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience generation job.
     * @see AudienceGenerationJobStatus
     */
    public final AudienceGenerationJobStatus status() {
        return AudienceGenerationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the audience generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience generation job.
     * @see AudienceGenerationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that was used for this audience generation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that was used for this audience
     *         generation job.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The identifier of the collaboration that contains this audience generation job.
     * </p>
     * 
     * @return The identifier of the collaboration that contains this audience generation job.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The AWS Account that submitted the job.
     * </p>
     * 
     * @return The AWS Account that submitted the job.
     */
    public final String startedBy() {
        return startedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceGenerationJobSummary)) {
            return false;
        }
        AudienceGenerationJobSummary other = (AudienceGenerationJobSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(audienceGenerationJobArn(), other.audienceGenerationJobArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(collaborationId(), other.collaborationId()) && Objects.equals(startedBy(), other.startedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceGenerationJobSummary").add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("AudienceGenerationJobArn", audienceGenerationJobArn()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("CollaborationId", collaborationId())
                .add("StartedBy", startedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "audienceGenerationJobArn":
            return Optional.ofNullable(clazz.cast(audienceGenerationJobArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("audienceGenerationJobArn", AUDIENCE_GENERATION_JOB_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("startedBy", STARTED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceGenerationJobSummary, T> g) {
        return obj -> g.apply((AudienceGenerationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceGenerationJobSummary> {
        /**
         * <p>
         * The time at which the audience generation job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the audience generation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the audience generation job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the audience generation job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience generation job.
         * </p>
         * 
         * @param audienceGenerationJobArn
         *        The Amazon Resource Name (ARN) of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobArn(String audienceGenerationJobArn);

        /**
         * <p>
         * The name of the audience generation job.
         * </p>
         * 
         * @param name
         *        The name of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the audience generation job.
         * </p>
         * 
         * @param description
         *        The description of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the audience generation job.
         * </p>
         * 
         * @param status
         *        The status of the audience generation job.
         * @see AudienceGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceGenerationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the audience generation job.
         * </p>
         * 
         * @param status
         *        The status of the audience generation job.
         * @see AudienceGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceGenerationJobStatus
         */
        Builder status(AudienceGenerationJobStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that was used for this audience generation
         * job.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that was used for this audience
         *        generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The identifier of the collaboration that contains this audience generation job.
         * </p>
         * 
         * @param collaborationId
         *        The identifier of the collaboration that contains this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The AWS Account that submitted the job.
         * </p>
         * 
         * @param startedBy
         *        The AWS Account that submitted the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String audienceGenerationJobArn;

        private String name;

        private String description;

        private String status;

        private String configuredAudienceModelArn;

        private String collaborationId;

        private String startedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceGenerationJobSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            audienceGenerationJobArn(model.audienceGenerationJobArn);
            name(model.name);
            description(model.description);
            status(model.status);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            collaborationId(model.collaborationId);
            startedBy(model.startedBy);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        @Override
        public AudienceGenerationJobSummary build() {
            return new AudienceGenerationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
