/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput;
import software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelsOutputCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollaborationTrainedModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollaborationTrainedModelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::createTime)).setter(CollaborationTrainedModelSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::updateTime)).setter(CollaborationTrainedModelSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::trainedModelArn)).setter(CollaborationTrainedModelSummary.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::name)).setter(CollaborationTrainedModelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionIdentifier").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::versionIdentifier)).setter(CollaborationTrainedModelSummary.setter(Builder::versionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()}).build();
    private static final SdkField<List<IncrementalTrainingDataChannelOutput>> INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incrementalTrainingDataChannels").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::incrementalTrainingDataChannels)).setter(CollaborationTrainedModelSummary.setter(Builder::incrementalTrainingDataChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalTrainingDataChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncrementalTrainingDataChannelOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::description)).setter(CollaborationTrainedModelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::membershipIdentifier)).setter(CollaborationTrainedModelSummary.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::collaborationIdentifier)).setter(CollaborationTrainedModelSummary.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::statusAsString)).setter(CollaborationTrainedModelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::configuredModelAlgorithmAssociationArn)).setter(CollaborationTrainedModelSummary.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(CollaborationTrainedModelSummary.getter(CollaborationTrainedModelSummary::creatorAccountId)).setter(CollaborationTrainedModelSummary.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, TRAINED_MODEL_ARN_FIELD, NAME_FIELD, VERSION_IDENTIFIER_FIELD, INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD, DESCRIPTION_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, STATUS_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, CREATOR_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollaborationTrainedModelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String trainedModelArn;
    private final String name;
    private final String versionIdentifier;
    private final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels;
    private final String description;
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final String status;
    private final String configuredModelAlgorithmAssociationArn;
    private final String creatorAccountId;

    private CollaborationTrainedModelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainedModelArn = builder.trainedModelArn;
        this.name = builder.name;
        this.versionIdentifier = builder.versionIdentifier;
        this.incrementalTrainingDataChannels = builder.incrementalTrainingDataChannels;
        this.description = builder.description;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.status = builder.status;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.creatorAccountId = builder.creatorAccountId;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String versionIdentifier() {
        return this.versionIdentifier;
    }

    public final boolean hasIncrementalTrainingDataChannels() {
        return this.incrementalTrainingDataChannels != null && !(this.incrementalTrainingDataChannels instanceof SdkAutoConstructList);
    }

    public final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels() {
        return this.incrementalTrainingDataChannels;
    }

    public final String description() {
        return this.description;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final TrainedModelStatus status() {
        return TrainedModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncrementalTrainingDataChannels() ? this.incrementalTrainingDataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationTrainedModelSummary)) {
            return false;
        }
        CollaborationTrainedModelSummary other = (CollaborationTrainedModelSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionIdentifier(), other.versionIdentifier()) && this.hasIncrementalTrainingDataChannels() == other.hasIncrementalTrainingDataChannels() && Objects.equals(this.incrementalTrainingDataChannels(), other.incrementalTrainingDataChannels()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"CollaborationTrainedModelSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("Name", (Object)this.name()).add("VersionIdentifier", (Object)this.versionIdentifier()).add("IncrementalTrainingDataChannels", this.hasIncrementalTrainingDataChannels() ? this.incrementalTrainingDataChannels() : null).add("Description", (Object)this.description()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("Status", (Object)this.statusAsString()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("CreatorAccountId", (Object)this.creatorAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.versionIdentifier()));
            }
            case "incrementalTrainingDataChannels": {
                return Optional.ofNullable(clazz.cast(this.incrementalTrainingDataChannels()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("incrementalTrainingDataChannels", INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationTrainedModelSummary, T> g) {
        return obj -> g.apply((CollaborationTrainedModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String trainedModelArn;
        private String name;
        private String versionIdentifier;
        private List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private String status;
        private String configuredModelAlgorithmAssociationArn;
        private String creatorAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationTrainedModelSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.trainedModelArn(model.trainedModelArn);
            this.name(model.name);
            this.versionIdentifier(model.versionIdentifier);
            this.incrementalTrainingDataChannels(model.incrementalTrainingDataChannels);
            this.description(model.description);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.status(model.status);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.creatorAccountId(model.creatorAccountId);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionIdentifier() {
            return this.versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final List<IncrementalTrainingDataChannelOutput.Builder> getIncrementalTrainingDataChannels() {
            List<IncrementalTrainingDataChannelOutput.Builder> result = IncrementalTrainingDataChannelsOutputCopier.copyToBuilder(this.incrementalTrainingDataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannelOutput.BuilderImpl> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier.copyFromBuilder(incrementalTrainingDataChannels);
        }

        @Override
        public final Builder incrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier.copy(incrementalTrainingDataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannelOutput ... incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels(Arrays.asList(incrementalTrainingDataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(Consumer<IncrementalTrainingDataChannelOutput.Builder> ... incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels(Stream.of(incrementalTrainingDataChannels).map(c -> (IncrementalTrainingDataChannelOutput)((IncrementalTrainingDataChannelOutput.Builder)IncrementalTrainingDataChannelOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public CollaborationTrainedModelSummary build() {
            return new CollaborationTrainedModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollaborationTrainedModelSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder trainedModelArn(String var1);

        public Builder name(String var1);

        public Builder versionIdentifier(String var1);

        public Builder incrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannelOutput> var1);

        public Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannelOutput ... var1);

        public Builder incrementalTrainingDataChannels(Consumer<IncrementalTrainingDataChannelOutput.Builder> ... var1);

        public Builder description(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(TrainedModelStatus var1);

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder creatorAccountId(String var1);
    }
}

