/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessBudgetType {
    CALENDAR_DAY("CALENDAR_DAY"),
    CALENDAR_MONTH("CALENDAR_MONTH"),
    CALENDAR_WEEK("CALENDAR_WEEK"),
    LIFETIME("LIFETIME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessBudgetType> VALUE_MAP;
    private final String value;

    private AccessBudgetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessBudgetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessBudgetType> knownValues() {
        EnumSet<AccessBudgetType> knownValues = EnumSet.allOf(AccessBudgetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessBudgetType.class, AccessBudgetType::toString);
    }
}

