/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMLInputChannelRequestConfiguredModelAlgorithmAssociationsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.InputChannel;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlInputChannelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CreateMlInputChannelRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::membershipIdentifier)).setter(CreateMlInputChannelRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithmAssociations").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::configuredModelAlgorithmAssociations)).setter(CreateMlInputChannelRequest.setter(Builder::configuredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputChannel> INPUT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputChannel").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::inputChannel)).setter(CreateMlInputChannelRequest.setter(Builder::inputChannel)).constructor(InputChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannel").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::name)).setter(CreateMlInputChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionInDays").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::retentionInDays)).setter(CreateMlInputChannelRequest.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::description)).setter(CreateMlInputChannelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::kmsKeyArn)).setter(CreateMlInputChannelRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMlInputChannelRequest.getter(CreateMlInputChannelRequest::tags)).setter(CreateMlInputChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, INPUT_CHANNEL_FIELD, NAME_FIELD, RETENTION_IN_DAYS_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMlInputChannelRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final List<String> configuredModelAlgorithmAssociations;
    private final InputChannel inputChannel;
    private final String name;
    private final Integer retentionInDays;
    private final String description;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private CreateMlInputChannelRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.inputChannel = builder.inputChannel;
        this.name = builder.name;
        this.retentionInDays = builder.retentionInDays;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations != null && !(this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<String> configuredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations;
    }

    public final InputChannel inputChannel() {
        return this.inputChannel;
    }

    public final String name() {
        return this.name;
    }

    public final Integer retentionInDays() {
        return this.retentionInDays;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlInputChannelRequest)) {
            return false;
        }
        CreateMlInputChannelRequest other = (CreateMlInputChannelRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && this.hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations() && Objects.equals(this.configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations()) && Objects.equals(this.inputChannel(), other.inputChannel()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMlInputChannelRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("ConfiguredModelAlgorithmAssociations", this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null).add("InputChannel", (Object)this.inputChannel()).add("Name", (Object)this.name()).add("RetentionInDays", (Object)this.retentionInDays()).add("Description", (Object)this.description()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "configuredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociations()));
            }
            case "inputChannel": {
                return Optional.ofNullable(clazz.cast(this.inputChannel()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        map.put("inputChannel", INPUT_CHANNEL_FIELD);
        map.put("name", NAME_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMlInputChannelRequest, T> g) {
        return obj -> g.apply((CreateMlInputChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();
        private InputChannel inputChannel;
        private String name;
        private Integer retentionInDays;
        private String description;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlInputChannelRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            this.inputChannel(model.inputChannel);
            this.name(model.name);
            this.retentionInDays(model.retentionInDays);
            this.description(model.description);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CreateMLInputChannelRequestConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CreateMLInputChannelRequestConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String ... configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final InputChannel.Builder getInputChannel() {
            return this.inputChannel != null ? this.inputChannel.toBuilder() : null;
        }

        public final void setInputChannel(InputChannel.BuilderImpl inputChannel) {
            this.inputChannel = inputChannel != null ? inputChannel.build() : null;
        }

        @Override
        public final Builder inputChannel(InputChannel inputChannel) {
            this.inputChannel = inputChannel;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlInputChannelRequest build() {
            return new CreateMlInputChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlInputChannelRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder configuredModelAlgorithmAssociations(Collection<String> var1);

        public Builder configuredModelAlgorithmAssociations(String ... var1);

        public Builder inputChannel(InputChannel var1);

        default public Builder inputChannel(Consumer<InputChannel.Builder> inputChannel) {
            return this.inputChannel((InputChannel)((InputChannel.Builder)InputChannel.builder().applyMutation(inputChannel)).build());
        }

        public Builder name(String var1);

        public Builder retentionInDays(Integer var1);

        public Builder description(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

