/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceContainerExecutionParameters;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceEnvironmentMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceResourceConfig;
import software.amazon.awssdk.services.cleanroomsml.model.ModelInferenceDataSource;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTrainedModelInferenceJobRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, StartTrainedModelInferenceJobRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::membershipIdentifier)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::name)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::trainedModelArn)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::configuredModelAlgorithmAssociationArn)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<InferenceResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfig").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::resourceConfig)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::resourceConfig)).constructor(InferenceResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::outputConfiguration)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::outputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<ModelInferenceDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::dataSource)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::dataSource)).constructor(ModelInferenceDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::description)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<InferenceContainerExecutionParameters> CONTAINER_EXECUTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerExecutionParameters").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::containerExecutionParameters)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::containerExecutionParameters)).constructor(InferenceContainerExecutionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerExecutionParameters").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environment").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::environment)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::kmsKeyArn)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartTrainedModelInferenceJobRequest.getter(StartTrainedModelInferenceJobRequest::tags)).setter(StartTrainedModelInferenceJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, TRAINED_MODEL_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, RESOURCE_CONFIG_FIELD, OUTPUT_CONFIGURATION_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, CONTAINER_EXECUTION_PARAMETERS_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartTrainedModelInferenceJobRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String name;
    private final String trainedModelArn;
    private final String configuredModelAlgorithmAssociationArn;
    private final InferenceResourceConfig resourceConfig;
    private final InferenceOutputConfiguration outputConfiguration;
    private final ModelInferenceDataSource dataSource;
    private final String description;
    private final InferenceContainerExecutionParameters containerExecutionParameters;
    private final Map<String, String> environment;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private StartTrainedModelInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.trainedModelArn = builder.trainedModelArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.resourceConfig = builder.resourceConfig;
        this.outputConfiguration = builder.outputConfiguration;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.containerExecutionParameters = builder.containerExecutionParameters;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final InferenceResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final InferenceOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final ModelInferenceDataSource dataSource() {
        return this.dataSource;
    }

    public final String description() {
        return this.description;
    }

    public final InferenceContainerExecutionParameters containerExecutionParameters() {
        return this.containerExecutionParameters;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerExecutionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTrainedModelInferenceJobRequest)) {
            return false;
        }
        StartTrainedModelInferenceJobRequest other = (StartTrainedModelInferenceJobRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.containerExecutionParameters(), other.containerExecutionParameters()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartTrainedModelInferenceJobRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Name", (Object)this.name()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("ResourceConfig", (Object)this.resourceConfig()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("DataSource", (Object)this.dataSource()).add("Description", (Object)this.description()).add("ContainerExecutionParameters", (Object)this.containerExecutionParameters()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "resourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "containerExecutionParameters": {
                return Optional.ofNullable(clazz.cast(this.containerExecutionParameters()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("containerExecutionParameters", CONTAINER_EXECUTION_PARAMETERS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTrainedModelInferenceJobRequest, T> g) {
        return obj -> g.apply((StartTrainedModelInferenceJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String name;
        private String trainedModelArn;
        private String configuredModelAlgorithmAssociationArn;
        private InferenceResourceConfig resourceConfig;
        private InferenceOutputConfiguration outputConfiguration;
        private ModelInferenceDataSource dataSource;
        private String description;
        private InferenceContainerExecutionParameters containerExecutionParameters;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTrainedModelInferenceJobRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.name(model.name);
            this.trainedModelArn(model.trainedModelArn);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.resourceConfig(model.resourceConfig);
            this.outputConfiguration(model.outputConfiguration);
            this.dataSource(model.dataSource);
            this.description(model.description);
            this.containerExecutionParameters(model.containerExecutionParameters);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final InferenceResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(InferenceResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(InferenceResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final ModelInferenceDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(ModelInferenceDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ModelInferenceDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InferenceContainerExecutionParameters.Builder getContainerExecutionParameters() {
            return this.containerExecutionParameters != null ? this.containerExecutionParameters.toBuilder() : null;
        }

        public final void setContainerExecutionParameters(InferenceContainerExecutionParameters.BuilderImpl containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters != null ? containerExecutionParameters.build() : null;
        }

        @Override
        public final Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTrainedModelInferenceJobRequest build() {
            return new StartTrainedModelInferenceJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTrainedModelInferenceJobRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder name(String var1);

        public Builder trainedModelArn(String var1);

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder resourceConfig(InferenceResourceConfig var1);

        default public Builder resourceConfig(Consumer<InferenceResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((InferenceResourceConfig)((InferenceResourceConfig.Builder)InferenceResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder outputConfiguration(InferenceOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder dataSource(ModelInferenceDataSource var1);

        default public Builder dataSource(Consumer<ModelInferenceDataSource.Builder> dataSource) {
            return this.dataSource((ModelInferenceDataSource)((ModelInferenceDataSource.Builder)ModelInferenceDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder description(String var1);

        public Builder containerExecutionParameters(InferenceContainerExecutionParameters var1);

        default public Builder containerExecutionParameters(Consumer<InferenceContainerExecutionParameters.Builder> containerExecutionParameters) {
            return this.containerExecutionParameters((InferenceContainerExecutionParameters)((InferenceContainerExecutionParameters.Builder)InferenceContainerExecutionParameters.builder().applyMutation(containerExecutionParameters)).build());
        }

        public Builder environment(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

