/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationTrainedModelInferenceJobsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListCollaborationTrainedModelInferenceJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationTrainedModelInferenceJobsResponse.getter(ListCollaborationTrainedModelInferenceJobsResponse::nextToken)).setter(ListCollaborationTrainedModelInferenceJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationTrainedModelInferenceJobSummary>> COLLABORATION_TRAINED_MODEL_INFERENCE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationTrainedModelInferenceJobs").getter(ListCollaborationTrainedModelInferenceJobsResponse.getter(ListCollaborationTrainedModelInferenceJobsResponse::collaborationTrainedModelInferenceJobs)).setter(ListCollaborationTrainedModelInferenceJobsResponse.setter(Builder::collaborationTrainedModelInferenceJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationTrainedModelInferenceJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationTrainedModelInferenceJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_TRAINED_MODEL_INFERENCE_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollaborationTrainedModelInferenceJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs;

    private ListCollaborationTrainedModelInferenceJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationTrainedModelInferenceJobs = builder.collaborationTrainedModelInferenceJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationTrainedModelInferenceJobs() {
        return this.collaborationTrainedModelInferenceJobs != null && !(this.collaborationTrainedModelInferenceJobs instanceof SdkAutoConstructList);
    }

    public final List<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs() {
        return this.collaborationTrainedModelInferenceJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationTrainedModelInferenceJobs() ? this.collaborationTrainedModelInferenceJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationTrainedModelInferenceJobsResponse)) {
            return false;
        }
        ListCollaborationTrainedModelInferenceJobsResponse other = (ListCollaborationTrainedModelInferenceJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationTrainedModelInferenceJobs() == other.hasCollaborationTrainedModelInferenceJobs() && Objects.equals(this.collaborationTrainedModelInferenceJobs(), other.collaborationTrainedModelInferenceJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationTrainedModelInferenceJobsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationTrainedModelInferenceJobs", this.hasCollaborationTrainedModelInferenceJobs() ? this.collaborationTrainedModelInferenceJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationTrainedModelInferenceJobs": {
                return Optional.ofNullable(clazz.cast(this.collaborationTrainedModelInferenceJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationTrainedModelInferenceJobs", COLLABORATION_TRAINED_MODEL_INFERENCE_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationTrainedModelInferenceJobsResponse, T> g) {
        return obj -> g.apply((ListCollaborationTrainedModelInferenceJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationTrainedModelInferenceJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationTrainedModelInferenceJobs(model.collaborationTrainedModelInferenceJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationTrainedModelInferenceJobSummary.Builder> getCollaborationTrainedModelInferenceJobs() {
            List<CollaborationTrainedModelInferenceJobSummary.Builder> result = CollaborationTrainedModelInferenceJobListCopier.copyToBuilder(this.collaborationTrainedModelInferenceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationTrainedModelInferenceJobs(Collection<CollaborationTrainedModelInferenceJobSummary.BuilderImpl> collaborationTrainedModelInferenceJobs) {
            this.collaborationTrainedModelInferenceJobs = CollaborationTrainedModelInferenceJobListCopier.copyFromBuilder(collaborationTrainedModelInferenceJobs);
        }

        @Override
        public final Builder collaborationTrainedModelInferenceJobs(Collection<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs) {
            this.collaborationTrainedModelInferenceJobs = CollaborationTrainedModelInferenceJobListCopier.copy(collaborationTrainedModelInferenceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelInferenceJobs(CollaborationTrainedModelInferenceJobSummary ... collaborationTrainedModelInferenceJobs) {
            this.collaborationTrainedModelInferenceJobs(Arrays.asList(collaborationTrainedModelInferenceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelInferenceJobs(Consumer<CollaborationTrainedModelInferenceJobSummary.Builder> ... collaborationTrainedModelInferenceJobs) {
            this.collaborationTrainedModelInferenceJobs(Stream.of(collaborationTrainedModelInferenceJobs).map(c -> (CollaborationTrainedModelInferenceJobSummary)((CollaborationTrainedModelInferenceJobSummary.Builder)CollaborationTrainedModelInferenceJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationTrainedModelInferenceJobsResponse build() {
            return new ListCollaborationTrainedModelInferenceJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationTrainedModelInferenceJobsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationTrainedModelInferenceJobs(Collection<CollaborationTrainedModelInferenceJobSummary> var1);

        public Builder collaborationTrainedModelInferenceJobs(CollaborationTrainedModelInferenceJobSummary ... var1);

        public Builder collaborationTrainedModelInferenceJobs(Consumer<CollaborationTrainedModelInferenceJobSummary.Builder> ... var1);
    }
}

