/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrainedModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, GetTrainedModelRequest> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(GetTrainedModelRequest.getter(GetTrainedModelRequest::trainedModelArn)).setter(GetTrainedModelRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetTrainedModelRequest.getter(GetTrainedModelRequest::membershipIdentifier)).setter(GetTrainedModelRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTrainedModelRequest.memberNameToFieldInitializer();
    private final String trainedModelArn;
    private final String membershipIdentifier;

    private GetTrainedModelRequest(BuilderImpl builder) {
        super(builder);
        this.trainedModelArn = builder.trainedModelArn;
        this.membershipIdentifier = builder.membershipIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainedModelRequest)) {
            return false;
        }
        GetTrainedModelRequest other = (GetTrainedModelRequest)((Object)obj);
        return Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrainedModelRequest").add("TrainedModelArn", (Object)this.trainedModelArn()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrainedModelRequest, T> g) {
        return obj -> g.apply((GetTrainedModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String trainedModelArn;
        private String membershipIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainedModelRequest model) {
            super(model);
            this.trainedModelArn(model.trainedModelArn);
            this.membershipIdentifier(model.membershipIdentifier);
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTrainedModelRequest build() {
            return new GetTrainedModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrainedModelRequest> {
        public Builder trainedModelArn(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

