/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelSummary;

public class ListMLInputChannelsIterable
implements SdkIterable<ListMlInputChannelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListMlInputChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMLInputChannelsIterable(CleanRoomsMlClient client, ListMlInputChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMlInputChannelsResponseFetcher();
    }

    public Iterator<ListMlInputChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MLInputChannelSummary> mlInputChannelsList() {
        Function<ListMlInputChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mlInputChannelsList() != null) {
                return response.mlInputChannelsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMlInputChannelsResponseFetcher
    implements SyncPageFetcher<ListMlInputChannelsResponse> {
        private ListMlInputChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlInputChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMlInputChannelsResponse nextPage(ListMlInputChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListMLInputChannelsIterable.this.client.listMLInputChannels(ListMLInputChannelsIterable.this.firstRequest);
            }
            return ListMLInputChannelsIterable.this.client.listMLInputChannels((ListMlInputChannelsRequest)((Object)ListMLInputChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

