/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudienceGenerationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudienceGenerationJobSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::createTime)).setter(AudienceGenerationJobSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::updateTime)).setter(AudienceGenerationJobSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceGenerationJobArn").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::audienceGenerationJobArn)).setter(AudienceGenerationJobSummary.setter(Builder::audienceGenerationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::name)).setter(AudienceGenerationJobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::description)).setter(AudienceGenerationJobSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::statusAsString)).setter(AudienceGenerationJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::configuredAudienceModelArn)).setter(AudienceGenerationJobSummary.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::collaborationId)).setter(AudienceGenerationJobSummary.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(AudienceGenerationJobSummary.getter(AudienceGenerationJobSummary::startedBy)).setter(AudienceGenerationJobSummary.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, AUDIENCE_GENERATION_JOB_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, COLLABORATION_ID_FIELD, STARTED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("audienceGenerationJobArn", AUDIENCE_GENERATION_JOB_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
            this.put("collaborationId", COLLABORATION_ID_FIELD);
            this.put("startedBy", STARTED_BY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String audienceGenerationJobArn;
    private final String name;
    private final String description;
    private final String status;
    private final String configuredAudienceModelArn;
    private final String collaborationId;
    private final String startedBy;

    private AudienceGenerationJobSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.collaborationId = builder.collaborationId;
        this.startedBy = builder.startedBy;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String audienceGenerationJobArn() {
        return this.audienceGenerationJobArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AudienceGenerationJobStatus status() {
        return AudienceGenerationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceGenerationJobSummary)) {
            return false;
        }
        AudienceGenerationJobSummary other = (AudienceGenerationJobSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.audienceGenerationJobArn(), other.audienceGenerationJobArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.startedBy(), other.startedBy());
    }

    public final String toString() {
        return ToString.builder((String)"AudienceGenerationJobSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("AudienceGenerationJobArn", (Object)this.audienceGenerationJobArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("CollaborationId", (Object)this.collaborationId()).add("StartedBy", (Object)this.startedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "audienceGenerationJobArn": {
                return Optional.ofNullable(clazz.cast(this.audienceGenerationJobArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AudienceGenerationJobSummary, T> g) {
        return obj -> g.apply((AudienceGenerationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String audienceGenerationJobArn;
        private String name;
        private String description;
        private String status;
        private String configuredAudienceModelArn;
        private String collaborationId;
        private String startedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceGenerationJobSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.audienceGenerationJobArn(model.audienceGenerationJobArn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.collaborationId(model.collaborationId);
            this.startedBy(model.startedBy);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return this.audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public AudienceGenerationJobSummary build() {
            return new AudienceGenerationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudienceGenerationJobSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder audienceGenerationJobArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AudienceGenerationJobStatus var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder collaborationId(String var1);

        public Builder startedBy(String var1);
    }
}

