/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.ColumnSchema;
import software.amazon.awssdk.services.cleanroomsml.model.DataSource;
import software.amazon.awssdk.services.cleanroomsml.model.DatasetInputConfigSchemaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetInputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetInputConfig> {
    private static final SdkField<List<ColumnSchema>> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schema").getter(DatasetInputConfig.getter(DatasetInputConfig::schema)).setter(DatasetInputConfig.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(DatasetInputConfig.getter(DatasetInputConfig::dataSource)).setter(DatasetInputConfig.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD, DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("schema", SCHEMA_FIELD);
            this.put("dataSource", DATA_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ColumnSchema> schema;
    private final DataSource dataSource;

    private DatasetInputConfig(BuilderImpl builder) {
        this.schema = builder.schema;
        this.dataSource = builder.dataSource;
    }

    public final boolean hasSchema() {
        return this.schema != null && !(this.schema instanceof SdkAutoConstructList);
    }

    public final List<ColumnSchema> schema() {
        return this.schema;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchema() ? this.schema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetInputConfig)) {
            return false;
        }
        DatasetInputConfig other = (DatasetInputConfig)obj;
        return this.hasSchema() == other.hasSchema() && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.dataSource(), other.dataSource());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetInputConfig").add("Schema", this.hasSchema() ? this.schema() : null).add("DataSource", (Object)this.dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetInputConfig, T> g) {
        return obj -> g.apply((DatasetInputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnSchema> schema = DefaultSdkAutoConstructList.getInstance();
        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetInputConfig model) {
            this.schema(model.schema);
            this.dataSource(model.dataSource);
        }

        public final List<ColumnSchema.Builder> getSchema() {
            List<ColumnSchema.Builder> result = DatasetInputConfigSchemaListCopier.copyToBuilder(this.schema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchema(Collection<ColumnSchema.BuilderImpl> schema) {
            this.schema = DatasetInputConfigSchemaListCopier.copyFromBuilder(schema);
        }

        @Override
        public final Builder schema(Collection<ColumnSchema> schema) {
            this.schema = DatasetInputConfigSchemaListCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(ColumnSchema ... schema) {
            this.schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<ColumnSchema.Builder> ... schema) {
            this.schema(Stream.of(schema).map(c -> (ColumnSchema)((ColumnSchema.Builder)ColumnSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DatasetInputConfig build() {
            return new DatasetInputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetInputConfig> {
        public Builder schema(Collection<ColumnSchema> var1);

        public Builder schema(ColumnSchema ... var1);

        public Builder schema(Consumer<ColumnSchema.Builder> ... var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }
    }
}

