/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.ChangeSpecification;
import software.amazon.awssdk.services.cleanrooms.model.ChangeSpecificationType;
import software.amazon.awssdk.services.cleanrooms.model.ChangeType;
import software.amazon.awssdk.services.cleanrooms.model.ChangeTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Change
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Change> {
    private static final SdkField<String> SPECIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("specificationType").getter(Change.getter(Change::specificationTypeAsString)).setter(Change.setter(Builder::specificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificationType").build()}).build();
    private static final SdkField<ChangeSpecification> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("specification").getter(Change.getter(Change::specification)).setter(Change.setter(Builder::specification)).constructor(ChangeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specification").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(Change.getter(Change::typesAsStrings)).setter(Change.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECIFICATION_TYPE_FIELD, SPECIFICATION_FIELD, TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Change.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String specificationType;
    private final ChangeSpecification specification;
    private final List<String> types;

    private Change(BuilderImpl builder) {
        this.specificationType = builder.specificationType;
        this.specification = builder.specification;
        this.types = builder.types;
    }

    public final ChangeSpecificationType specificationType() {
        return ChangeSpecificationType.fromValue(this.specificationType);
    }

    public final String specificationTypeAsString() {
        return this.specificationType;
    }

    public final ChangeSpecification specification() {
        return this.specification;
    }

    public final List<ChangeType> types() {
        return ChangeTypeListCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.specificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.specification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        return Objects.equals(this.specificationTypeAsString(), other.specificationTypeAsString()) && Objects.equals(this.specification(), other.specification()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Change").add("SpecificationType", (Object)this.specificationTypeAsString()).add("Specification", (Object)this.specification()).add("Types", this.hasTypes() ? this.typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "specificationType": {
                return Optional.ofNullable(clazz.cast(this.specificationTypeAsString()));
            }
            case "specification": {
                return Optional.ofNullable(clazz.cast(this.specification()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specificationType", SPECIFICATION_TYPE_FIELD);
        map.put("specification", SPECIFICATION_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String specificationType;
        private ChangeSpecification specification;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.specificationType(model.specificationType);
            this.specification(model.specification);
            this.typesWithStrings(model.types);
        }

        public final String getSpecificationType() {
            return this.specificationType;
        }

        public final void setSpecificationType(String specificationType) {
            this.specificationType = specificationType;
        }

        @Override
        public final Builder specificationType(String specificationType) {
            this.specificationType = specificationType;
            return this;
        }

        @Override
        public final Builder specificationType(ChangeSpecificationType specificationType) {
            this.specificationType(specificationType == null ? null : specificationType.toString());
            return this;
        }

        public final ChangeSpecification.Builder getSpecification() {
            return this.specification != null ? this.specification.toBuilder() : null;
        }

        public final void setSpecification(ChangeSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(ChangeSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ChangeTypeListCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ChangeTypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<ChangeType> types) {
            this.types = ChangeTypeListCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(ChangeType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public Change build() {
            return new Change(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Change> {
        public Builder specificationType(String var1);

        public Builder specificationType(ChangeSpecificationType var1);

        public Builder specification(ChangeSpecification var1);

        default public Builder specification(Consumer<ChangeSpecification.Builder> specification) {
            return this.specification((ChangeSpecification)((ChangeSpecification.Builder)ChangeSpecification.builder().applyMutation(specification)).build());
        }

        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<ChangeType> var1);

        public Builder types(ChangeType ... var1);
    }
}

