/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdNamespaceAssociationResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<UpdateIdNamespaceAssociationResponse.Builder, UpdateIdNamespaceAssociationResponse> {
    private static final SdkField<IdNamespaceAssociation> ID_NAMESPACE_ASSOCIATION_FIELD = SdkField
            .<IdNamespaceAssociation> builder(MarshallingType.SDK_POJO).memberName("idNamespaceAssociation")
            .getter(getter(UpdateIdNamespaceAssociationResponse::idNamespaceAssociation))
            .setter(setter(Builder::idNamespaceAssociation)).constructor(IdNamespaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_NAMESPACE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IdNamespaceAssociation idNamespaceAssociation;

    private UpdateIdNamespaceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.idNamespaceAssociation = builder.idNamespaceAssociation;
    }

    /**
     * <p>
     * The updated ID namespace association.
     * </p>
     * 
     * @return The updated ID namespace association.
     */
    public final IdNamespaceAssociation idNamespaceAssociation() {
        return idNamespaceAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdNamespaceAssociationResponse)) {
            return false;
        }
        UpdateIdNamespaceAssociationResponse other = (UpdateIdNamespaceAssociationResponse) obj;
        return Objects.equals(idNamespaceAssociation(), other.idNamespaceAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdNamespaceAssociationResponse").add("IdNamespaceAssociation", idNamespaceAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceAssociation":
            return Optional.ofNullable(clazz.cast(idNamespaceAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceAssociation", ID_NAMESPACE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdNamespaceAssociationResponse, T> g) {
        return obj -> g.apply((UpdateIdNamespaceAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdNamespaceAssociationResponse> {
        /**
         * <p>
         * The updated ID namespace association.
         * </p>
         * 
         * @param idNamespaceAssociation
         *        The updated ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceAssociation(IdNamespaceAssociation idNamespaceAssociation);

        /**
         * <p>
         * The updated ID namespace association.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdNamespaceAssociation.Builder} avoiding
         * the need to create one manually via {@link IdNamespaceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdNamespaceAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #idNamespaceAssociation(IdNamespaceAssociation)}.
         * 
         * @param idNamespaceAssociation
         *        a consumer that will call methods on {@link IdNamespaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idNamespaceAssociation(IdNamespaceAssociation)
         */
        default Builder idNamespaceAssociation(Consumer<IdNamespaceAssociation.Builder> idNamespaceAssociation) {
            return idNamespaceAssociation(IdNamespaceAssociation.builder().applyMutation(idNamespaceAssociation).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private IdNamespaceAssociation idNamespaceAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdNamespaceAssociationResponse model) {
            super(model);
            idNamespaceAssociation(model.idNamespaceAssociation);
        }

        public final IdNamespaceAssociation.Builder getIdNamespaceAssociation() {
            return idNamespaceAssociation != null ? idNamespaceAssociation.toBuilder() : null;
        }

        public final void setIdNamespaceAssociation(IdNamespaceAssociation.BuilderImpl idNamespaceAssociation) {
            this.idNamespaceAssociation = idNamespaceAssociation != null ? idNamespaceAssociation.build() : null;
        }

        @Override
        public final Builder idNamespaceAssociation(IdNamespaceAssociation idNamespaceAssociation) {
            this.idNamespaceAssociation = idNamespaceAssociation;
            return this;
        }

        @Override
        public UpdateIdNamespaceAssociationResponse build() {
            return new UpdateIdNamespaceAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
