/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that control how synthetic data is generated, including privacy settings, column classifications, and
 * other configuration options that affect the data synthesis process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyntheticDataParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SyntheticDataParameters.Builder, SyntheticDataParameters> {
    private static final SdkField<MLSyntheticDataParameters> ML_SYNTHETIC_DATA_PARAMETERS_FIELD = SdkField
            .<MLSyntheticDataParameters> builder(MarshallingType.SDK_POJO).memberName("mlSyntheticDataParameters")
            .getter(getter(SyntheticDataParameters::mlSyntheticDataParameters))
            .setter(setter(Builder::mlSyntheticDataParameters)).constructor(MLSyntheticDataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlSyntheticDataParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ML_SYNTHETIC_DATA_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MLSyntheticDataParameters mlSyntheticDataParameters;

    private final Type type;

    private SyntheticDataParameters(BuilderImpl builder) {
        this.mlSyntheticDataParameters = builder.mlSyntheticDataParameters;
        this.type = builder.type;
    }

    /**
     * <p>
     * The machine learning-specific parameters for synthetic data generation.
     * </p>
     * 
     * @return The machine learning-specific parameters for synthetic data generation.
     */
    public final MLSyntheticDataParameters mlSyntheticDataParameters() {
        return mlSyntheticDataParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlSyntheticDataParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntheticDataParameters)) {
            return false;
        }
        SyntheticDataParameters other = (SyntheticDataParameters) obj;
        return Objects.equals(mlSyntheticDataParameters(), other.mlSyntheticDataParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyntheticDataParameters").add("MlSyntheticDataParameters", mlSyntheticDataParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mlSyntheticDataParameters":
            return Optional.ofNullable(clazz.cast(mlSyntheticDataParameters()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #mlSyntheticDataParameters()} initialized to the given value.
     *
     * <p>
     * The machine learning-specific parameters for synthetic data generation.
     * </p>
     * 
     * @param mlSyntheticDataParameters
     *        The machine learning-specific parameters for synthetic data generation.
     */
    public static SyntheticDataParameters fromMlSyntheticDataParameters(MLSyntheticDataParameters mlSyntheticDataParameters) {
        return builder().mlSyntheticDataParameters(mlSyntheticDataParameters).build();
    }

    /**
     * Create an instance of this class with {@link #mlSyntheticDataParameters()} initialized to the given value.
     *
     * <p>
     * The machine learning-specific parameters for synthetic data generation.
     * </p>
     * 
     * @param mlSyntheticDataParameters
     *        The machine learning-specific parameters for synthetic data generation.
     */
    public static SyntheticDataParameters fromMlSyntheticDataParameters(
            Consumer<MLSyntheticDataParameters.Builder> mlSyntheticDataParameters) {
        MLSyntheticDataParameters.Builder builder = MLSyntheticDataParameters.builder();
        mlSyntheticDataParameters.accept(builder);
        return fromMlSyntheticDataParameters(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mlSyntheticDataParameters", ML_SYNTHETIC_DATA_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyntheticDataParameters, T> g) {
        return obj -> g.apply((SyntheticDataParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyntheticDataParameters> {
        /**
         * <p>
         * The machine learning-specific parameters for synthetic data generation.
         * </p>
         * 
         * @param mlSyntheticDataParameters
         *        The machine learning-specific parameters for synthetic data generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlSyntheticDataParameters(MLSyntheticDataParameters mlSyntheticDataParameters);

        /**
         * <p>
         * The machine learning-specific parameters for synthetic data generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLSyntheticDataParameters.Builder}
         * avoiding the need to create one manually via {@link MLSyntheticDataParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLSyntheticDataParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #mlSyntheticDataParameters(MLSyntheticDataParameters)}.
         * 
         * @param mlSyntheticDataParameters
         *        a consumer that will call methods on {@link MLSyntheticDataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlSyntheticDataParameters(MLSyntheticDataParameters)
         */
        default Builder mlSyntheticDataParameters(Consumer<MLSyntheticDataParameters.Builder> mlSyntheticDataParameters) {
            return mlSyntheticDataParameters(MLSyntheticDataParameters.builder().applyMutation(mlSyntheticDataParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MLSyntheticDataParameters mlSyntheticDataParameters;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SyntheticDataParameters model) {
            mlSyntheticDataParameters(model.mlSyntheticDataParameters);
        }

        public final MLSyntheticDataParameters.Builder getMlSyntheticDataParameters() {
            return mlSyntheticDataParameters != null ? mlSyntheticDataParameters.toBuilder() : null;
        }

        public final void setMlSyntheticDataParameters(MLSyntheticDataParameters.BuilderImpl mlSyntheticDataParameters) {
            Object oldValue = this.mlSyntheticDataParameters;
            this.mlSyntheticDataParameters = mlSyntheticDataParameters != null ? mlSyntheticDataParameters.build() : null;
            handleUnionValueChange(Type.ML_SYNTHETIC_DATA_PARAMETERS, oldValue, this.mlSyntheticDataParameters);
        }

        @Override
        public final Builder mlSyntheticDataParameters(MLSyntheticDataParameters mlSyntheticDataParameters) {
            Object oldValue = this.mlSyntheticDataParameters;
            this.mlSyntheticDataParameters = mlSyntheticDataParameters;
            handleUnionValueChange(Type.ML_SYNTHETIC_DATA_PARAMETERS, oldValue, this.mlSyntheticDataParameters);
            return this;
        }

        @Override
        public SyntheticDataParameters build() {
            return new SyntheticDataParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SyntheticDataParameters#type()
     */
    public enum Type {
        ML_SYNTHETIC_DATA_PARAMETERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
