/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the collaboration member's payment responsibilities set by the collaboration creator for query
 * compute costs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryComputePaymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryComputePaymentConfig.Builder, QueryComputePaymentConfig> {
    private static final SdkField<Boolean> IS_RESPONSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isResponsible").getter(getter(QueryComputePaymentConfig::isResponsible))
            .setter(setter(Builder::isResponsible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResponsible").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_RESPONSIBLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isResponsible;

    private QueryComputePaymentConfig(BuilderImpl builder) {
        this.isResponsible = builder.isResponsible;
    }

    /**
     * <p>
     * Indicates whether the collaboration creator has configured the collaboration member to pay for query compute
     * costs (<code>TRUE</code>) or has not configured the collaboration member to pay for query compute costs (
     * <code>FALSE</code>).
     * </p>
     * <p>
     * Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration
     * creator sets a <code>TRUE</code> value for more than one member in the collaboration.
     * </p>
     * <p>
     * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the
     * member who can query is the default payer. An error is returned if the collaboration creator sets a
     * <code>FALSE</code> value for the member who can query.
     * </p>
     * 
     * @return Indicates whether the collaboration creator has configured the collaboration member to pay for query
     *         compute costs (<code>TRUE</code>) or has not configured the collaboration member to pay for query compute
     *         costs (<code>FALSE</code>).</p>
     *         <p>
     *         Exactly one member can be configured to pay for query compute costs. An error is returned if the
     *         collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
     *         </p>
     *         <p>
     *         If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then
     *         the member who can query is the default payer. An error is returned if the collaboration creator sets a
     *         <code>FALSE</code> value for the member who can query.
     */
    public final Boolean isResponsible() {
        return isResponsible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isResponsible());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryComputePaymentConfig)) {
            return false;
        }
        QueryComputePaymentConfig other = (QueryComputePaymentConfig) obj;
        return Objects.equals(isResponsible(), other.isResponsible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryComputePaymentConfig").add("IsResponsible", isResponsible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isResponsible":
            return Optional.ofNullable(clazz.cast(isResponsible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isResponsible", IS_RESPONSIBLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryComputePaymentConfig, T> g) {
        return obj -> g.apply((QueryComputePaymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryComputePaymentConfig> {
        /**
         * <p>
         * Indicates whether the collaboration creator has configured the collaboration member to pay for query compute
         * costs (<code>TRUE</code>) or has not configured the collaboration member to pay for query compute costs (
         * <code>FALSE</code>).
         * </p>
         * <p>
         * Exactly one member can be configured to pay for query compute costs. An error is returned if the
         * collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
         * </p>
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the
         * member who can query is the default payer. An error is returned if the collaboration creator sets a
         * <code>FALSE</code> value for the member who can query.
         * </p>
         * 
         * @param isResponsible
         *        Indicates whether the collaboration creator has configured the collaboration member to pay for query
         *        compute costs (<code>TRUE</code>) or has not configured the collaboration member to pay for query
         *        compute costs (<code>FALSE</code>).</p>
         *        <p>
         *        Exactly one member can be configured to pay for query compute costs. An error is returned if the
         *        collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
         *        </p>
         *        <p>
         *        If the collaboration creator hasn't specified anyone as the member paying for query compute costs,
         *        then the member who can query is the default payer. An error is returned if the collaboration creator
         *        sets a <code>FALSE</code> value for the member who can query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isResponsible(Boolean isResponsible);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isResponsible;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryComputePaymentConfig model) {
            isResponsible(model.isResponsible);
        }

        public final Boolean getIsResponsible() {
            return isResponsible;
        }

        public final void setIsResponsible(Boolean isResponsible) {
            this.isResponsible = isResponsible;
        }

        @Override
        public final Builder isResponsible(Boolean isResponsible) {
            this.isResponsible = isResponsible;
            return this;
        }

        @Override
        public QueryComputePaymentConfig build() {
            return new QueryComputePaymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
