/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains statistics about the execution of the protected job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobStatistics.Builder, ProtectedJobStatistics> {
    private static final SdkField<Long> TOTAL_DURATION_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDurationInMillis").getter(getter(ProtectedJobStatistics::totalDurationInMillis))
            .setter(setter(Builder::totalDurationInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDurationInMillis").build())
            .build();

    private static final SdkField<BilledJobResourceUtilization> BILLED_RESOURCE_UTILIZATION_FIELD = SdkField
            .<BilledJobResourceUtilization> builder(MarshallingType.SDK_POJO).memberName("billedResourceUtilization")
            .getter(getter(ProtectedJobStatistics::billedResourceUtilization)).setter(setter(Builder::billedResourceUtilization))
            .constructor(BilledJobResourceUtilization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billedResourceUtilization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_DURATION_IN_MILLIS_FIELD, BILLED_RESOURCE_UTILIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long totalDurationInMillis;

    private final BilledJobResourceUtilization billedResourceUtilization;

    private ProtectedJobStatistics(BuilderImpl builder) {
        this.totalDurationInMillis = builder.totalDurationInMillis;
        this.billedResourceUtilization = builder.billedResourceUtilization;
    }

    /**
     * <p>
     * The duration of the protected job, from creation until job completion, in milliseconds.
     * </p>
     * 
     * @return The duration of the protected job, from creation until job completion, in milliseconds.
     */
    public final Long totalDurationInMillis() {
        return totalDurationInMillis;
    }

    /**
     * <p>
     * The billed resource utilization for the protected job.
     * </p>
     * 
     * @return The billed resource utilization for the protected job.
     */
    public final BilledJobResourceUtilization billedResourceUtilization() {
        return billedResourceUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalDurationInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(billedResourceUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobStatistics)) {
            return false;
        }
        ProtectedJobStatistics other = (ProtectedJobStatistics) obj;
        return Objects.equals(totalDurationInMillis(), other.totalDurationInMillis())
                && Objects.equals(billedResourceUtilization(), other.billedResourceUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobStatistics").add("TotalDurationInMillis", totalDurationInMillis())
                .add("BilledResourceUtilization", billedResourceUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalDurationInMillis":
            return Optional.ofNullable(clazz.cast(totalDurationInMillis()));
        case "billedResourceUtilization":
            return Optional.ofNullable(clazz.cast(billedResourceUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalDurationInMillis", TOTAL_DURATION_IN_MILLIS_FIELD);
        map.put("billedResourceUtilization", BILLED_RESOURCE_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobStatistics, T> g) {
        return obj -> g.apply((ProtectedJobStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobStatistics> {
        /**
         * <p>
         * The duration of the protected job, from creation until job completion, in milliseconds.
         * </p>
         * 
         * @param totalDurationInMillis
         *        The duration of the protected job, from creation until job completion, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDurationInMillis(Long totalDurationInMillis);

        /**
         * <p>
         * The billed resource utilization for the protected job.
         * </p>
         * 
         * @param billedResourceUtilization
         *        The billed resource utilization for the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billedResourceUtilization(BilledJobResourceUtilization billedResourceUtilization);

        /**
         * <p>
         * The billed resource utilization for the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BilledJobResourceUtilization.Builder}
         * avoiding the need to create one manually via {@link BilledJobResourceUtilization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BilledJobResourceUtilization.Builder#build()} is called
         * immediately and its result is passed to {@link #billedResourceUtilization(BilledJobResourceUtilization)}.
         * 
         * @param billedResourceUtilization
         *        a consumer that will call methods on {@link BilledJobResourceUtilization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billedResourceUtilization(BilledJobResourceUtilization)
         */
        default Builder billedResourceUtilization(Consumer<BilledJobResourceUtilization.Builder> billedResourceUtilization) {
            return billedResourceUtilization(BilledJobResourceUtilization.builder().applyMutation(billedResourceUtilization)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long totalDurationInMillis;

        private BilledJobResourceUtilization billedResourceUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobStatistics model) {
            totalDurationInMillis(model.totalDurationInMillis);
            billedResourceUtilization(model.billedResourceUtilization);
        }

        public final Long getTotalDurationInMillis() {
            return totalDurationInMillis;
        }

        public final void setTotalDurationInMillis(Long totalDurationInMillis) {
            this.totalDurationInMillis = totalDurationInMillis;
        }

        @Override
        public final Builder totalDurationInMillis(Long totalDurationInMillis) {
            this.totalDurationInMillis = totalDurationInMillis;
            return this;
        }

        public final BilledJobResourceUtilization.Builder getBilledResourceUtilization() {
            return billedResourceUtilization != null ? billedResourceUtilization.toBuilder() : null;
        }

        public final void setBilledResourceUtilization(BilledJobResourceUtilization.BuilderImpl billedResourceUtilization) {
            this.billedResourceUtilization = billedResourceUtilization != null ? billedResourceUtilization.build() : null;
        }

        @Override
        public final Builder billedResourceUtilization(BilledJobResourceUtilization billedResourceUtilization) {
            this.billedResourceUtilization = billedResourceUtilization;
            return this;
        }

        @Override
        public ProtectedJobStatistics build() {
            return new ProtectedJobStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
