/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protected job output configuration output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobOutputConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobOutputConfigurationOutput.Builder, ProtectedJobOutputConfigurationOutput> {
    private static final SdkField<ProtectedJobS3OutputConfigurationOutput> S3_FIELD = SdkField
            .<ProtectedJobS3OutputConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(ProtectedJobOutputConfigurationOutput::s3)).setter(setter(Builder::s3))
            .constructor(ProtectedJobS3OutputConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final SdkField<ProtectedJobMemberOutputConfigurationOutput> MEMBER_FIELD = SdkField
            .<ProtectedJobMemberOutputConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("member")
            .getter(getter(ProtectedJobOutputConfigurationOutput::member)).setter(setter(Builder::member))
            .constructor(ProtectedJobMemberOutputConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobS3OutputConfigurationOutput s3;

    private final ProtectedJobMemberOutputConfigurationOutput member;

    private final Type type;

    private ProtectedJobOutputConfigurationOutput(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.member = builder.member;
        this.type = builder.type;
    }

    /**
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @return If present, the output for a protected job with an `S3` output type.
     */
    public final ProtectedJobS3OutputConfigurationOutput s3() {
        return s3;
    }

    /**
     * <p>
     * The member output configuration for a protected job.
     * </p>
     * 
     * @return The member output configuration for a protected job.
     */
    public final ProtectedJobMemberOutputConfigurationOutput member() {
        return member;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(member());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobOutputConfigurationOutput)) {
            return false;
        }
        ProtectedJobOutputConfigurationOutput other = (ProtectedJobOutputConfigurationOutput) obj;
        return Objects.equals(s3(), other.s3()) && Objects.equals(member(), other.member());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobOutputConfigurationOutput").add("S3", s3()).add("Member", member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "member":
            return Optional.ofNullable(clazz.cast(member()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @param s3
     *        If present, the output for a protected job with an `S3` output type.
     */
    public static ProtectedJobOutputConfigurationOutput fromS3(ProtectedJobS3OutputConfigurationOutput s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @param s3
     *        If present, the output for a protected job with an `S3` output type.
     */
    public static ProtectedJobOutputConfigurationOutput fromS3(Consumer<ProtectedJobS3OutputConfigurationOutput.Builder> s3) {
        ProtectedJobS3OutputConfigurationOutput.Builder builder = ProtectedJobS3OutputConfigurationOutput.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #member()} initialized to the given value.
     *
     * <p>
     * The member output configuration for a protected job.
     * </p>
     * 
     * @param member
     *        The member output configuration for a protected job.
     */
    public static ProtectedJobOutputConfigurationOutput fromMember(ProtectedJobMemberOutputConfigurationOutput member) {
        return builder().member(member).build();
    }

    /**
     * Create an instance of this class with {@link #member()} initialized to the given value.
     *
     * <p>
     * The member output configuration for a protected job.
     * </p>
     * 
     * @param member
     *        The member output configuration for a protected job.
     */
    public static ProtectedJobOutputConfigurationOutput fromMember(
            Consumer<ProtectedJobMemberOutputConfigurationOutput.Builder> member) {
        ProtectedJobMemberOutputConfigurationOutput.Builder builder = ProtectedJobMemberOutputConfigurationOutput.builder();
        member.accept(builder);
        return fromMember(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3", S3_FIELD);
        map.put("member", MEMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobOutputConfigurationOutput, T> g) {
        return obj -> g.apply((ProtectedJobOutputConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobOutputConfigurationOutput> {
        /**
         * <p>
         * If present, the output for a protected job with an `S3` output type.
         * </p>
         * 
         * @param s3
         *        If present, the output for a protected job with an `S3` output type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(ProtectedJobS3OutputConfigurationOutput s3);

        /**
         * <p>
         * If present, the output for a protected job with an `S3` output type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobS3OutputConfigurationOutput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobS3OutputConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobS3OutputConfigurationOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #s3(ProtectedJobS3OutputConfigurationOutput)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link ProtectedJobS3OutputConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(ProtectedJobS3OutputConfigurationOutput)
         */
        default Builder s3(Consumer<ProtectedJobS3OutputConfigurationOutput.Builder> s3) {
            return s3(ProtectedJobS3OutputConfigurationOutput.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * The member output configuration for a protected job.
         * </p>
         * 
         * @param member
         *        The member output configuration for a protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(ProtectedJobMemberOutputConfigurationOutput member);

        /**
         * <p>
         * The member output configuration for a protected job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobMemberOutputConfigurationOutput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobMemberOutputConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobMemberOutputConfigurationOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #member(ProtectedJobMemberOutputConfigurationOutput)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link ProtectedJobMemberOutputConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(ProtectedJobMemberOutputConfigurationOutput)
         */
        default Builder member(Consumer<ProtectedJobMemberOutputConfigurationOutput.Builder> member) {
            return member(ProtectedJobMemberOutputConfigurationOutput.builder().applyMutation(member).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobS3OutputConfigurationOutput s3;

        private ProtectedJobMemberOutputConfigurationOutput member;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobOutputConfigurationOutput model) {
            s3(model.s3);
            member(model.member);
        }

        public final ProtectedJobS3OutputConfigurationOutput.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(ProtectedJobS3OutputConfigurationOutput.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(ProtectedJobS3OutputConfigurationOutput s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final ProtectedJobMemberOutputConfigurationOutput.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(ProtectedJobMemberOutputConfigurationOutput.BuilderImpl member) {
            Object oldValue = this.member;
            this.member = member != null ? member.build() : null;
            handleUnionValueChange(Type.MEMBER, oldValue, this.member);
        }

        @Override
        public final Builder member(ProtectedJobMemberOutputConfigurationOutput member) {
            Object oldValue = this.member;
            this.member = member;
            handleUnionValueChange(Type.MEMBER, oldValue, this.member);
            return this;
        }

        @Override
        public ProtectedJobOutputConfigurationOutput build() {
            return new ProtectedJobOutputConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProtectedJobOutputConfigurationOutput#type()
     */
    public enum Type {
        S3,

        MEMBER,

        UNKNOWN_TO_SDK_VERSION
    }
}
