/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the protected job output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobOutput.Builder, ProtectedJobOutput> {
    private static final SdkField<ProtectedJobS3Output> S3_FIELD = SdkField
            .<ProtectedJobS3Output> builder(MarshallingType.SDK_POJO).memberName("s3").getter(getter(ProtectedJobOutput::s3))
            .setter(setter(Builder::s3)).constructor(ProtectedJobS3Output::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final SdkField<List<ProtectedJobSingleMemberOutput>> MEMBER_LIST_FIELD = SdkField
            .<List<ProtectedJobSingleMemberOutput>> builder(MarshallingType.LIST)
            .memberName("memberList")
            .getter(getter(ProtectedJobOutput::memberList))
            .setter(setter(Builder::memberList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectedJobSingleMemberOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectedJobSingleMemberOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobS3Output s3;

    private final List<ProtectedJobSingleMemberOutput> memberList;

    private final Type type;

    private ProtectedJobOutput(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.memberList = builder.memberList;
        this.type = builder.type;
    }

    /**
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @return If present, the output for a protected job with an `S3` output type.
     */
    public final ProtectedJobS3Output s3() {
        return s3;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMemberList() {
        return memberList != null && !(memberList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of member Amazon Web Services account(s) that received the results of the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberList} method.
     * </p>
     * 
     * @return The list of member Amazon Web Services account(s) that received the results of the job.
     */
    public final List<ProtectedJobSingleMemberOutput> memberList() {
        return memberList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberList() ? memberList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobOutput)) {
            return false;
        }
        ProtectedJobOutput other = (ProtectedJobOutput) obj;
        return Objects.equals(s3(), other.s3()) && hasMemberList() == other.hasMemberList()
                && Objects.equals(memberList(), other.memberList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobOutput").add("S3", s3()).add("MemberList", hasMemberList() ? memberList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "memberList":
            return Optional.ofNullable(clazz.cast(memberList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @param s3
     *        If present, the output for a protected job with an `S3` output type.
     */
    public static ProtectedJobOutput fromS3(ProtectedJobS3Output s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * If present, the output for a protected job with an `S3` output type.
     * </p>
     * 
     * @param s3
     *        If present, the output for a protected job with an `S3` output type.
     */
    public static ProtectedJobOutput fromS3(Consumer<ProtectedJobS3Output.Builder> s3) {
        ProtectedJobS3Output.Builder builder = ProtectedJobS3Output.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #memberList()} initialized to the given value.
     *
     * <p>
     * The list of member Amazon Web Services account(s) that received the results of the job.
     * </p>
     * 
     * @param memberList
     *        The list of member Amazon Web Services account(s) that received the results of the job.
     */
    public static ProtectedJobOutput fromMemberList(List<ProtectedJobSingleMemberOutput> memberList) {
        return builder().memberList(memberList).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3", S3_FIELD);
        map.put("memberList", MEMBER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobOutput, T> g) {
        return obj -> g.apply((ProtectedJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobOutput> {
        /**
         * <p>
         * If present, the output for a protected job with an `S3` output type.
         * </p>
         * 
         * @param s3
         *        If present, the output for a protected job with an `S3` output type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(ProtectedJobS3Output s3);

        /**
         * <p>
         * If present, the output for a protected job with an `S3` output type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobS3Output.Builder} avoiding
         * the need to create one manually via {@link ProtectedJobS3Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobS3Output.Builder#build()} is called immediately and
         * its result is passed to {@link #s3(ProtectedJobS3Output)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link ProtectedJobS3Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(ProtectedJobS3Output)
         */
        default Builder s3(Consumer<ProtectedJobS3Output.Builder> s3) {
            return s3(ProtectedJobS3Output.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * The list of member Amazon Web Services account(s) that received the results of the job.
         * </p>
         * 
         * @param memberList
         *        The list of member Amazon Web Services account(s) that received the results of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberList(Collection<ProtectedJobSingleMemberOutput> memberList);

        /**
         * <p>
         * The list of member Amazon Web Services account(s) that received the results of the job.
         * </p>
         * 
         * @param memberList
         *        The list of member Amazon Web Services account(s) that received the results of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberList(ProtectedJobSingleMemberOutput... memberList);

        /**
         * <p>
         * The list of member Amazon Web Services account(s) that received the results of the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSingleMemberOutput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSingleMemberOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSingleMemberOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #memberList(List<ProtectedJobSingleMemberOutput>)}.
         * 
         * @param memberList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSingleMemberOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberList(java.util.Collection<ProtectedJobSingleMemberOutput>)
         */
        Builder memberList(Consumer<ProtectedJobSingleMemberOutput.Builder>... memberList);
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobS3Output s3;

        private List<ProtectedJobSingleMemberOutput> memberList = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobOutput model) {
            s3(model.s3);
            memberList(model.memberList);
        }

        public final ProtectedJobS3Output.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(ProtectedJobS3Output.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(ProtectedJobS3Output s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final List<ProtectedJobSingleMemberOutput.Builder> getMemberList() {
            List<ProtectedJobSingleMemberOutput.Builder> result = ProtectedJobMemberOutputListCopier
                    .copyToBuilder(this.memberList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberList(Collection<ProtectedJobSingleMemberOutput.BuilderImpl> memberList) {
            Object oldValue = this.memberList;
            this.memberList = ProtectedJobMemberOutputListCopier.copyFromBuilder(memberList);
            handleUnionValueChange(Type.MEMBER_LIST, oldValue, this.memberList);
        }

        @Override
        public final Builder memberList(Collection<ProtectedJobSingleMemberOutput> memberList) {
            Object oldValue = this.memberList;
            this.memberList = ProtectedJobMemberOutputListCopier.copy(memberList);
            handleUnionValueChange(Type.MEMBER_LIST, oldValue, this.memberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(ProtectedJobSingleMemberOutput... memberList) {
            memberList(Arrays.asList(memberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(Consumer<ProtectedJobSingleMemberOutput.Builder>... memberList) {
            memberList(Stream.of(memberList).map(c -> ProtectedJobSingleMemberOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProtectedJobOutput build() {
            return new ProtectedJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProtectedJobOutput#type()
     */
    public enum Type {
        S3,

        MEMBER_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
