/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the compute resources for a PySpark job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobComputeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobComputeConfiguration.Builder, ProtectedJobComputeConfiguration> {
    private static final SdkField<ProtectedJobWorkerComputeConfiguration> WORKER_FIELD = SdkField
            .<ProtectedJobWorkerComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("worker")
            .getter(getter(ProtectedJobComputeConfiguration::worker)).setter(setter(Builder::worker))
            .constructor(ProtectedJobWorkerComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobWorkerComputeConfiguration worker;

    private final Type type;

    private ProtectedJobComputeConfiguration(BuilderImpl builder) {
        this.worker = builder.worker;
        this.type = builder.type;
    }

    /**
     * <p>
     * The worker configuration for the compute environment.
     * </p>
     * 
     * @return The worker configuration for the compute environment.
     */
    public final ProtectedJobWorkerComputeConfiguration worker() {
        return worker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(worker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobComputeConfiguration)) {
            return false;
        }
        ProtectedJobComputeConfiguration other = (ProtectedJobComputeConfiguration) obj;
        return Objects.equals(worker(), other.worker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobComputeConfiguration").add("Worker", worker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "worker":
            return Optional.ofNullable(clazz.cast(worker()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #worker()} initialized to the given value.
     *
     * <p>
     * The worker configuration for the compute environment.
     * </p>
     * 
     * @param worker
     *        The worker configuration for the compute environment.
     */
    public static ProtectedJobComputeConfiguration fromWorker(ProtectedJobWorkerComputeConfiguration worker) {
        return builder().worker(worker).build();
    }

    /**
     * Create an instance of this class with {@link #worker()} initialized to the given value.
     *
     * <p>
     * The worker configuration for the compute environment.
     * </p>
     * 
     * @param worker
     *        The worker configuration for the compute environment.
     */
    public static ProtectedJobComputeConfiguration fromWorker(Consumer<ProtectedJobWorkerComputeConfiguration.Builder> worker) {
        ProtectedJobWorkerComputeConfiguration.Builder builder = ProtectedJobWorkerComputeConfiguration.builder();
        worker.accept(builder);
        return fromWorker(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("worker", WORKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobComputeConfiguration, T> g) {
        return obj -> g.apply((ProtectedJobComputeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobComputeConfiguration> {
        /**
         * <p>
         * The worker configuration for the compute environment.
         * </p>
         * 
         * @param worker
         *        The worker configuration for the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worker(ProtectedJobWorkerComputeConfiguration worker);

        /**
         * <p>
         * The worker configuration for the compute environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobWorkerComputeConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobWorkerComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobWorkerComputeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #worker(ProtectedJobWorkerComputeConfiguration)}.
         * 
         * @param worker
         *        a consumer that will call methods on {@link ProtectedJobWorkerComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worker(ProtectedJobWorkerComputeConfiguration)
         */
        default Builder worker(Consumer<ProtectedJobWorkerComputeConfiguration.Builder> worker) {
            return worker(ProtectedJobWorkerComputeConfiguration.builder().applyMutation(worker).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobWorkerComputeConfiguration worker;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobComputeConfiguration model) {
            worker(model.worker);
        }

        public final ProtectedJobWorkerComputeConfiguration.Builder getWorker() {
            return worker != null ? worker.toBuilder() : null;
        }

        public final void setWorker(ProtectedJobWorkerComputeConfiguration.BuilderImpl worker) {
            Object oldValue = this.worker;
            this.worker = worker != null ? worker.build() : null;
            handleUnionValueChange(Type.WORKER, oldValue, this.worker);
        }

        @Override
        public final Builder worker(ProtectedJobWorkerComputeConfiguration worker) {
            Object oldValue = this.worker;
            this.worker = worker;
            handleUnionValueChange(Type.WORKER, oldValue, this.worker);
            return this;
        }

        @Override
        public ProtectedJobComputeConfiguration build() {
            return new ProtectedJobComputeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProtectedJobComputeConfiguration#type()
     */
    public enum Type {
        WORKER,

        UNKNOWN_TO_SDK_VERSION
    }
}
