/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the privacy budget template. The summary includes membership information, collaboration information, and
 * creation information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyBudgetTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyBudgetTemplateSummary.Builder, PrivacyBudgetTemplateSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PrivacyBudgetTemplateSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PrivacyBudgetTemplateSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(PrivacyBudgetTemplateSummary::membershipId))
            .setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(PrivacyBudgetTemplateSummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(PrivacyBudgetTemplateSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(PrivacyBudgetTemplateSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetType").getter(getter(PrivacyBudgetTemplateSummary::privacyBudgetTypeAsString))
            .setter(setter(Builder::privacyBudgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(PrivacyBudgetTemplateSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(PrivacyBudgetTemplateSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD,
            PRIVACY_BUDGET_TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String membershipId;

    private final String membershipArn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String privacyBudgetType;

    private final Instant createTime;

    private final Instant updateTime;

    private PrivacyBudgetTemplateSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The unique identifier of the privacy budget template.
     * </p>
     * 
     * @return The unique identifier of the privacy budget template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the privacy budget template.
     * </p>
     * 
     * @return The ARN of the privacy budget template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier for a membership resource.
     * </p>
     * 
     * @return The identifier for a membership resource.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the member who created the privacy budget template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the member who created the privacy budget template.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The unique ID of the collaboration that contains this privacy budget template.
     * </p>
     * 
     * @return The unique ID of the collaboration that contains this privacy budget template.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The ARN of the collaboration that contains this privacy budget template.
     * </p>
     * 
     * @return The ARN of the collaboration that contains this privacy budget template.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return The type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(privacyBudgetType);
    }

    /**
     * <p>
     * The type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return The type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final String privacyBudgetTypeAsString() {
        return privacyBudgetType;
    }

    /**
     * <p>
     * The time at which the privacy budget template was created.
     * </p>
     * 
     * @return The time at which the privacy budget template was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the privacy budget template was updated.
     * </p>
     * 
     * @return The most recent time at which the privacy budget template was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetTemplateSummary)) {
            return false;
        }
        PrivacyBudgetTemplateSummary other = (PrivacyBudgetTemplateSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyBudgetTemplateSummary").add("Id", id()).add("Arn", arn())
                .add("MembershipId", membershipId()).add("MembershipArn", membershipArn())
                .add("CollaborationId", collaborationId()).add("CollaborationArn", collaborationArn())
                .add("PrivacyBudgetType", privacyBudgetTypeAsString()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "privacyBudgetType":
            return Optional.ofNullable(clazz.cast(privacyBudgetTypeAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetTemplateSummary, T> g) {
        return obj -> g.apply((PrivacyBudgetTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyBudgetTemplateSummary> {
        /**
         * <p>
         * The unique identifier of the privacy budget template.
         * </p>
         * 
         * @param id
         *        The unique identifier of the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the privacy budget template.
         * </p>
         * 
         * @param arn
         *        The ARN of the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier for a membership resource.
         * </p>
         * 
         * @param membershipId
         *        The identifier for a membership resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the member who created the privacy budget template.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the member who created the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The unique ID of the collaboration that contains this privacy budget template.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID of the collaboration that contains this privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The ARN of the collaboration that contains this privacy budget template.
         * </p>
         * 
         * @param collaborationArn
         *        The ARN of the collaboration that contains this privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        The type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(String privacyBudgetType);

        /**
         * <p>
         * The type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        The type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType);

        /**
         * <p>
         * The time at which the privacy budget template was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the privacy budget template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the privacy budget template was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the privacy budget template was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String membershipId;

        private String membershipArn;

        private String collaborationId;

        private String collaborationArn;

        private String privacyBudgetType;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetTemplateSummary model) {
            id(model.id);
            arn(model.arn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            privacyBudgetType(model.privacyBudgetType);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getPrivacyBudgetType() {
            return privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public PrivacyBudgetTemplateSummary build() {
            return new PrivacyBudgetTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
