/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The epsilon and noise parameters that you want to use for the privacy budget template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyBudgetTemplateParametersInput implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyBudgetTemplateParametersInput.Builder, PrivacyBudgetTemplateParametersInput> {
    private static final SdkField<DifferentialPrivacyTemplateParametersInput> DIFFERENTIAL_PRIVACY_FIELD = SdkField
            .<DifferentialPrivacyTemplateParametersInput> builder(MarshallingType.SDK_POJO).memberName("differentialPrivacy")
            .getter(getter(PrivacyBudgetTemplateParametersInput::differentialPrivacy))
            .setter(setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyTemplateParametersInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build())
            .build();

    private static final SdkField<AccessBudgetsPrivacyTemplateParametersInput> ACCESS_BUDGET_FIELD = SdkField
            .<AccessBudgetsPrivacyTemplateParametersInput> builder(MarshallingType.SDK_POJO).memberName("accessBudget")
            .getter(getter(PrivacyBudgetTemplateParametersInput::accessBudget)).setter(setter(Builder::accessBudget))
            .constructor(AccessBudgetsPrivacyTemplateParametersInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessBudget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENTIAL_PRIVACY_FIELD,
            ACCESS_BUDGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DifferentialPrivacyTemplateParametersInput differentialPrivacy;

    private final AccessBudgetsPrivacyTemplateParametersInput accessBudget;

    private final Type type;

    private PrivacyBudgetTemplateParametersInput(BuilderImpl builder) {
        this.differentialPrivacy = builder.differentialPrivacy;
        this.accessBudget = builder.accessBudget;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that specifies the epsilon and noise parameters.
     * </p>
     * 
     * @return An object that specifies the epsilon and noise parameters.
     */
    public final DifferentialPrivacyTemplateParametersInput differentialPrivacy() {
        return differentialPrivacy;
    }

    /**
     * <p>
     * Access budget configuration for the privacy budget template input, enabling integration with access budget
     * functionality.
     * </p>
     * 
     * @return Access budget configuration for the privacy budget template input, enabling integration with access
     *         budget functionality.
     */
    public final AccessBudgetsPrivacyTemplateParametersInput accessBudget() {
        return accessBudget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(differentialPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(accessBudget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetTemplateParametersInput)) {
            return false;
        }
        PrivacyBudgetTemplateParametersInput other = (PrivacyBudgetTemplateParametersInput) obj;
        return Objects.equals(differentialPrivacy(), other.differentialPrivacy())
                && Objects.equals(accessBudget(), other.accessBudget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyBudgetTemplateParametersInput").add("DifferentialPrivacy", differentialPrivacy())
                .add("AccessBudget", accessBudget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "differentialPrivacy":
            return Optional.ofNullable(clazz.cast(differentialPrivacy()));
        case "accessBudget":
            return Optional.ofNullable(clazz.cast(accessBudget()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * An object that specifies the epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        An object that specifies the epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateParametersInput fromDifferentialPrivacy(
            DifferentialPrivacyTemplateParametersInput differentialPrivacy) {
        return builder().differentialPrivacy(differentialPrivacy).build();
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * An object that specifies the epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        An object that specifies the epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateParametersInput fromDifferentialPrivacy(
            Consumer<DifferentialPrivacyTemplateParametersInput.Builder> differentialPrivacy) {
        DifferentialPrivacyTemplateParametersInput.Builder builder = DifferentialPrivacyTemplateParametersInput.builder();
        differentialPrivacy.accept(builder);
        return fromDifferentialPrivacy(builder.build());
    }

    /**
     * Create an instance of this class with {@link #accessBudget()} initialized to the given value.
     *
     * <p>
     * Access budget configuration for the privacy budget template input, enabling integration with access budget
     * functionality.
     * </p>
     * 
     * @param accessBudget
     *        Access budget configuration for the privacy budget template input, enabling integration with access budget
     *        functionality.
     */
    public static PrivacyBudgetTemplateParametersInput fromAccessBudget(AccessBudgetsPrivacyTemplateParametersInput accessBudget) {
        return builder().accessBudget(accessBudget).build();
    }

    /**
     * Create an instance of this class with {@link #accessBudget()} initialized to the given value.
     *
     * <p>
     * Access budget configuration for the privacy budget template input, enabling integration with access budget
     * functionality.
     * </p>
     * 
     * @param accessBudget
     *        Access budget configuration for the privacy budget template input, enabling integration with access budget
     *        functionality.
     */
    public static PrivacyBudgetTemplateParametersInput fromAccessBudget(
            Consumer<AccessBudgetsPrivacyTemplateParametersInput.Builder> accessBudget) {
        AccessBudgetsPrivacyTemplateParametersInput.Builder builder = AccessBudgetsPrivacyTemplateParametersInput.builder();
        accessBudget.accept(builder);
        return fromAccessBudget(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("differentialPrivacy", DIFFERENTIAL_PRIVACY_FIELD);
        map.put("accessBudget", ACCESS_BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetTemplateParametersInput, T> g) {
        return obj -> g.apply((PrivacyBudgetTemplateParametersInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyBudgetTemplateParametersInput> {
        /**
         * <p>
         * An object that specifies the epsilon and noise parameters.
         * </p>
         * 
         * @param differentialPrivacy
         *        An object that specifies the epsilon and noise parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differentialPrivacy(DifferentialPrivacyTemplateParametersInput differentialPrivacy);

        /**
         * <p>
         * An object that specifies the epsilon and noise parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DifferentialPrivacyTemplateParametersInput.Builder} avoiding the need to create one manually via
         * {@link DifferentialPrivacyTemplateParametersInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DifferentialPrivacyTemplateParametersInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #differentialPrivacy(DifferentialPrivacyTemplateParametersInput)}.
         * 
         * @param differentialPrivacy
         *        a consumer that will call methods on {@link DifferentialPrivacyTemplateParametersInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differentialPrivacy(DifferentialPrivacyTemplateParametersInput)
         */
        default Builder differentialPrivacy(Consumer<DifferentialPrivacyTemplateParametersInput.Builder> differentialPrivacy) {
            return differentialPrivacy(DifferentialPrivacyTemplateParametersInput.builder().applyMutation(differentialPrivacy)
                    .build());
        }

        /**
         * <p>
         * Access budget configuration for the privacy budget template input, enabling integration with access budget
         * functionality.
         * </p>
         * 
         * @param accessBudget
         *        Access budget configuration for the privacy budget template input, enabling integration with access
         *        budget functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessBudget(AccessBudgetsPrivacyTemplateParametersInput accessBudget);

        /**
         * <p>
         * Access budget configuration for the privacy budget template input, enabling integration with access budget
         * functionality.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccessBudgetsPrivacyTemplateParametersInput.Builder} avoiding the need to create one manually via
         * {@link AccessBudgetsPrivacyTemplateParametersInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessBudgetsPrivacyTemplateParametersInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #accessBudget(AccessBudgetsPrivacyTemplateParametersInput)}.
         * 
         * @param accessBudget
         *        a consumer that will call methods on {@link AccessBudgetsPrivacyTemplateParametersInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessBudget(AccessBudgetsPrivacyTemplateParametersInput)
         */
        default Builder accessBudget(Consumer<AccessBudgetsPrivacyTemplateParametersInput.Builder> accessBudget) {
            return accessBudget(AccessBudgetsPrivacyTemplateParametersInput.builder().applyMutation(accessBudget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DifferentialPrivacyTemplateParametersInput differentialPrivacy;

        private AccessBudgetsPrivacyTemplateParametersInput accessBudget;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetTemplateParametersInput model) {
            differentialPrivacy(model.differentialPrivacy);
            accessBudget(model.accessBudget);
        }

        public final DifferentialPrivacyTemplateParametersInput.Builder getDifferentialPrivacy() {
            return differentialPrivacy != null ? differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyTemplateParametersInput.BuilderImpl differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyTemplateParametersInput differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
            return this;
        }

        public final AccessBudgetsPrivacyTemplateParametersInput.Builder getAccessBudget() {
            return accessBudget != null ? accessBudget.toBuilder() : null;
        }

        public final void setAccessBudget(AccessBudgetsPrivacyTemplateParametersInput.BuilderImpl accessBudget) {
            Object oldValue = this.accessBudget;
            this.accessBudget = accessBudget != null ? accessBudget.build() : null;
            handleUnionValueChange(Type.ACCESS_BUDGET, oldValue, this.accessBudget);
        }

        @Override
        public final Builder accessBudget(AccessBudgetsPrivacyTemplateParametersInput accessBudget) {
            Object oldValue = this.accessBudget;
            this.accessBudget = accessBudget;
            handleUnionValueChange(Type.ACCESS_BUDGET, oldValue, this.accessBudget);
            return this;
        }

        @Override
        public PrivacyBudgetTemplateParametersInput build() {
            return new PrivacyBudgetTemplateParametersInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PrivacyBudgetTemplateParametersInput#type()
     */
    public enum Type {
        DIFFERENTIAL_PRIVACY,

        ACCESS_BUDGET,

        UNKNOWN_TO_SDK_VERSION
    }
}
