/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreviewPrivacyImpactResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<PreviewPrivacyImpactResponse.Builder, PreviewPrivacyImpactResponse> {
    private static final SdkField<PrivacyImpact> PRIVACY_IMPACT_FIELD = SdkField
            .<PrivacyImpact> builder(MarshallingType.SDK_POJO).memberName("privacyImpact")
            .getter(getter(PreviewPrivacyImpactResponse::privacyImpact)).setter(setter(Builder::privacyImpact))
            .constructor(PrivacyImpact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyImpact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVACY_IMPACT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PrivacyImpact privacyImpact;

    private PreviewPrivacyImpactResponse(BuilderImpl builder) {
        super(builder);
        this.privacyImpact = builder.privacyImpact;
    }

    /**
     * <p>
     * An estimate of the number of aggregation functions that the member who can query can run given the epsilon and
     * noise parameters. This does not change the privacy budget.
     * </p>
     * 
     * @return An estimate of the number of aggregation functions that the member who can query can run given the
     *         epsilon and noise parameters. This does not change the privacy budget.
     */
    public final PrivacyImpact privacyImpact() {
        return privacyImpact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(privacyImpact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewPrivacyImpactResponse)) {
            return false;
        }
        PreviewPrivacyImpactResponse other = (PreviewPrivacyImpactResponse) obj;
        return Objects.equals(privacyImpact(), other.privacyImpact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreviewPrivacyImpactResponse").add("PrivacyImpact", privacyImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "privacyImpact":
            return Optional.ofNullable(clazz.cast(privacyImpact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("privacyImpact", PRIVACY_IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewPrivacyImpactResponse, T> g) {
        return obj -> g.apply((PreviewPrivacyImpactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PreviewPrivacyImpactResponse> {
        /**
         * <p>
         * An estimate of the number of aggregation functions that the member who can query can run given the epsilon
         * and noise parameters. This does not change the privacy budget.
         * </p>
         * 
         * @param privacyImpact
         *        An estimate of the number of aggregation functions that the member who can query can run given the
         *        epsilon and noise parameters. This does not change the privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyImpact(PrivacyImpact privacyImpact);

        /**
         * <p>
         * An estimate of the number of aggregation functions that the member who can query can run given the epsilon
         * and noise parameters. This does not change the privacy budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyImpact.Builder} avoiding the need
         * to create one manually via {@link PrivacyImpact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyImpact.Builder#build()} is called immediately and its
         * result is passed to {@link #privacyImpact(PrivacyImpact)}.
         * 
         * @param privacyImpact
         *        a consumer that will call methods on {@link PrivacyImpact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyImpact(PrivacyImpact)
         */
        default Builder privacyImpact(Consumer<PrivacyImpact.Builder> privacyImpact) {
            return privacyImpact(PrivacyImpact.builder().applyMutation(privacyImpact).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private PrivacyImpact privacyImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewPrivacyImpactResponse model) {
            super(model);
            privacyImpact(model.privacyImpact);
        }

        public final PrivacyImpact.Builder getPrivacyImpact() {
            return privacyImpact != null ? privacyImpact.toBuilder() : null;
        }

        public final void setPrivacyImpact(PrivacyImpact.BuilderImpl privacyImpact) {
            this.privacyImpact = privacyImpact != null ? privacyImpact.build() : null;
        }

        @Override
        public final Builder privacyImpact(PrivacyImpact privacyImpact) {
            this.privacyImpact = privacyImpact;
            return this;
        }

        @Override
        public PreviewPrivacyImpactResponse build() {
            return new PreviewPrivacyImpactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
