/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PopulateIdMappingTableResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<PopulateIdMappingTableResponse.Builder, PopulateIdMappingTableResponse> {
    private static final SdkField<String> ID_MAPPING_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idMappingJobId").getter(getter(PopulateIdMappingTableResponse::idMappingJobId))
            .setter(setter(Builder::idMappingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_MAPPING_JOB_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String idMappingJobId;

    private PopulateIdMappingTableResponse(BuilderImpl builder) {
        super(builder);
        this.idMappingJobId = builder.idMappingJobId;
    }

    /**
     * <p>
     * The unique identifier of the mapping job that will populate the ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the mapping job that will populate the ID mapping table.
     */
    public final String idMappingJobId() {
        return idMappingJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idMappingJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PopulateIdMappingTableResponse)) {
            return false;
        }
        PopulateIdMappingTableResponse other = (PopulateIdMappingTableResponse) obj;
        return Objects.equals(idMappingJobId(), other.idMappingJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PopulateIdMappingTableResponse").add("IdMappingJobId", idMappingJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingJobId":
            return Optional.ofNullable(clazz.cast(idMappingJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingJobId", ID_MAPPING_JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PopulateIdMappingTableResponse, T> g) {
        return obj -> g.apply((PopulateIdMappingTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PopulateIdMappingTableResponse> {
        /**
         * <p>
         * The unique identifier of the mapping job that will populate the ID mapping table.
         * </p>
         * 
         * @param idMappingJobId
         *        The unique identifier of the mapping job that will populate the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingJobId(String idMappingJobId);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String idMappingJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(PopulateIdMappingTableResponse model) {
            super(model);
            idMappingJobId(model.idMappingJobId);
        }

        public final String getIdMappingJobId() {
            return idMappingJobId;
        }

        public final void setIdMappingJobId(String idMappingJobId) {
            this.idMappingJobId = idMappingJobId;
        }

        @Override
        public final Builder idMappingJobId(String idMappingJobId) {
            this.idMappingJobId = idMappingJobId;
            return this;
        }

        @Override
        public PopulateIdMappingTableResponse build() {
            return new PopulateIdMappingTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
