/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PopulateIdMappingTableRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<PopulateIdMappingTableRequest.Builder, PopulateIdMappingTableRequest> {
    private static final SdkField<String> ID_MAPPING_TABLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idMappingTableIdentifier").getter(getter(PopulateIdMappingTableRequest::idMappingTableIdentifier))
            .setter(setter(Builder::idMappingTableIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idMappingTableIdentifier").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(PopulateIdMappingTableRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(PopulateIdMappingTableRequest::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ID_MAPPING_TABLE_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, JOB_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String idMappingTableIdentifier;

    private final String membershipIdentifier;

    private final String jobType;

    private PopulateIdMappingTableRequest(BuilderImpl builder) {
        super(builder);
        this.idMappingTableIdentifier = builder.idMappingTableIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.jobType = builder.jobType;
    }

    /**
     * <p>
     * The unique identifier of the ID mapping table that you want to populate.
     * </p>
     * 
     * @return The unique identifier of the ID mapping table that you want to populate.
     */
    public final String idMappingTableIdentifier() {
        return idMappingTableIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the membership that contains the ID mapping table that you want to populate.
     * </p>
     * 
     * @return The unique identifier of the membership that contains the ID mapping table that you want to populate.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The job type of the rule-based ID mapping job. Valid values include:
     * </p>
     * <p>
     * <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default job type
     * if the ID mapping workflow was created in Entity Resolution with <code>incrementalRunConfig</code> specified.
     * </p>
     * <p>
     * <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is the
     * default job type if the ID mapping workflow was created in Entity Resolution but
     * <code>incrementalRunConfig</code> wasn't specified.
     * </p>
     * <p>
     * <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which is set in
     * Entity Resolution.
     * </p>
     * <p>
     * For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see the <a
     * href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity Resolution API
     * Reference</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type of the rule-based ID mapping job. Valid values include:</p>
     *         <p>
     *         <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default
     *         job type if the ID mapping workflow was created in Entity Resolution with
     *         <code>incrementalRunConfig</code> specified.
     *         </p>
     *         <p>
     *         <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is
     *         the default job type if the ID mapping workflow was created in Entity Resolution but
     *         <code>incrementalRunConfig</code> wasn't specified.
     *         </p>
     *         <p>
     *         <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which
     *         is set in Entity Resolution.
     *         </p>
     *         <p>
     *         For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see
     *         the <a href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity
     *         Resolution API Reference</a>.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The job type of the rule-based ID mapping job. Valid values include:
     * </p>
     * <p>
     * <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default job type
     * if the ID mapping workflow was created in Entity Resolution with <code>incrementalRunConfig</code> specified.
     * </p>
     * <p>
     * <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is the
     * default job type if the ID mapping workflow was created in Entity Resolution but
     * <code>incrementalRunConfig</code> wasn't specified.
     * </p>
     * <p>
     * <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which is set in
     * Entity Resolution.
     * </p>
     * <p>
     * For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see the <a
     * href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity Resolution API
     * Reference</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type of the rule-based ID mapping job. Valid values include:</p>
     *         <p>
     *         <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default
     *         job type if the ID mapping workflow was created in Entity Resolution with
     *         <code>incrementalRunConfig</code> specified.
     *         </p>
     *         <p>
     *         <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is
     *         the default job type if the ID mapping workflow was created in Entity Resolution but
     *         <code>incrementalRunConfig</code> wasn't specified.
     *         </p>
     *         <p>
     *         <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which
     *         is set in Entity Resolution.
     *         </p>
     *         <p>
     *         For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see
     *         the <a href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity
     *         Resolution API Reference</a>.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PopulateIdMappingTableRequest)) {
            return false;
        }
        PopulateIdMappingTableRequest other = (PopulateIdMappingTableRequest) obj;
        return Objects.equals(idMappingTableIdentifier(), other.idMappingTableIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PopulateIdMappingTableRequest").add("IdMappingTableIdentifier", idMappingTableIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).add("JobType", jobTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingTableIdentifier":
            return Optional.ofNullable(clazz.cast(idMappingTableIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingTableIdentifier", ID_MAPPING_TABLE_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PopulateIdMappingTableRequest, T> g) {
        return obj -> g.apply((PopulateIdMappingTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PopulateIdMappingTableRequest> {
        /**
         * <p>
         * The unique identifier of the ID mapping table that you want to populate.
         * </p>
         * 
         * @param idMappingTableIdentifier
         *        The unique identifier of the ID mapping table that you want to populate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTableIdentifier(String idMappingTableIdentifier);

        /**
         * <p>
         * The unique identifier of the membership that contains the ID mapping table that you want to populate.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique identifier of the membership that contains the ID mapping table that you want to populate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The job type of the rule-based ID mapping job. Valid values include:
         * </p>
         * <p>
         * <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default job
         * type if the ID mapping workflow was created in Entity Resolution with <code>incrementalRunConfig</code>
         * specified.
         * </p>
         * <p>
         * <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is the
         * default job type if the ID mapping workflow was created in Entity Resolution but
         * <code>incrementalRunConfig</code> wasn't specified.
         * </p>
         * <p>
         * <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which is
         * set in Entity Resolution.
         * </p>
         * <p>
         * For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see the <a
         * href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity Resolution API
         * Reference</a>.
         * </p>
         * 
         * @param jobType
         *        The job type of the rule-based ID mapping job. Valid values include:</p>
         *        <p>
         *        <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the
         *        default job type if the ID mapping workflow was created in Entity Resolution with
         *        <code>incrementalRunConfig</code> specified.
         *        </p>
         *        <p>
         *        <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is
         *        the default job type if the ID mapping workflow was created in Entity Resolution but
         *        <code>incrementalRunConfig</code> wasn't specified.
         *        </p>
         *        <p>
         *        <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>,
         *        which is set in Entity Resolution.
         *        </p>
         *        <p>
         *        For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see
         *        the <a href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity
         *        Resolution API Reference</a>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The job type of the rule-based ID mapping job. Valid values include:
         * </p>
         * <p>
         * <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the default job
         * type if the ID mapping workflow was created in Entity Resolution with <code>incrementalRunConfig</code>
         * specified.
         * </p>
         * <p>
         * <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is the
         * default job type if the ID mapping workflow was created in Entity Resolution but
         * <code>incrementalRunConfig</code> wasn't specified.
         * </p>
         * <p>
         * <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>, which is
         * set in Entity Resolution.
         * </p>
         * <p>
         * For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see the <a
         * href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity Resolution API
         * Reference</a>.
         * </p>
         * 
         * @param jobType
         *        The job type of the rule-based ID mapping job. Valid values include:</p>
         *        <p>
         *        <code>INCREMENTAL</code>: Processes only new or changed data since the last job run. This is the
         *        default job type if the ID mapping workflow was created in Entity Resolution with
         *        <code>incrementalRunConfig</code> specified.
         *        </p>
         *        <p>
         *        <code>BATCH</code>: Processes all data from the input source, regardless of previous job runs. This is
         *        the default job type if the ID mapping workflow was created in Entity Resolution but
         *        <code>incrementalRunConfig</code> wasn't specified.
         *        </p>
         *        <p>
         *        <code>DELETE_ONLY</code>: Processes only deletion requests from <code>BatchDeleteUniqueId</code>,
         *        which is set in Entity Resolution.
         *        </p>
         *        <p>
         *        For more information about <code>incrementalRunConfig</code> and <code>BatchDeleteUniqueId</code>, see
         *        the <a href="https://docs.aws.amazon.com/entityresolution/latest/apireference/Welcome.html">Entity
         *        Resolution API Reference</a>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String idMappingTableIdentifier;

        private String membershipIdentifier;

        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(PopulateIdMappingTableRequest model) {
            super(model);
            idMappingTableIdentifier(model.idMappingTableIdentifier);
            membershipIdentifier(model.membershipIdentifier);
            jobType(model.jobType);
        }

        public final String getIdMappingTableIdentifier() {
            return idMappingTableIdentifier;
        }

        public final void setIdMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
        }

        @Override
        public final Builder idMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PopulateIdMappingTableRequest build() {
            return new PopulateIdMappingTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
